% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_list_shards}
\alias{kinesis_list_shards}
\title{Lists the shards in a stream and provides information about each shard}
\usage{
kinesis_list_shards(
  StreamName = NULL,
  NextToken = NULL,
  ExclusiveStartShardId = NULL,
  MaxResults = NULL,
  StreamCreationTimestamp = NULL,
  ShardFilter = NULL,
  StreamARN = NULL
)
}
\arguments{
\item{StreamName}{The name of the data stream whose shards you want to list.

You cannot specify this parameter if you specify the \code{NextToken}
parameter.}

\item{NextToken}{When the number of shards in the data stream is greater than the default
value for the \code{MaxResults} parameter, or if you explicitly specify a
value for \code{MaxResults} that is less than the number of shards in the
data stream, the response includes a pagination token named \code{NextToken}.
You can specify this \code{NextToken} value in a subsequent call to
\code{\link[=kinesis_list_shards]{list_shards}} to list the next set of shards.

Don't specify \code{StreamName} or \code{StreamCreationTimestamp} if you specify
\code{NextToken} because the latter unambiguously identifies the stream.

You can optionally specify a value for the \code{MaxResults} parameter when
you specify \code{NextToken}. If you specify a \code{MaxResults} value that is
less than the number of shards that the operation returns if you don't
specify \code{MaxResults}, the response will contain a new \code{NextToken} value.
You can use the new \code{NextToken} value in a subsequent call to the
\code{\link[=kinesis_list_shards]{list_shards}} operation.

Tokens expire after 300 seconds. When you obtain a value for \code{NextToken}
in the response to a call to \code{\link[=kinesis_list_shards]{list_shards}}, you
have 300 seconds to use that value. If you specify an expired token in a
call to \code{\link[=kinesis_list_shards]{list_shards}}, you get
\code{ExpiredNextTokenException}.}

\item{ExclusiveStartShardId}{Specify this parameter to indicate that you want to list the shards
starting with the shard whose ID immediately follows
\code{ExclusiveStartShardId}.

If you don't specify this parameter, the default behavior is for
\code{\link[=kinesis_list_shards]{list_shards}} to list the shards starting with
the first one in the stream.

You cannot specify this parameter if you specify \code{NextToken}.}

\item{MaxResults}{The maximum number of shards to return in a single call to
\code{\link[=kinesis_list_shards]{list_shards}}. The maximum number of shards to
return in a single call. The default value is 1000. If you specify a
value greater than 1000, at most 1000 results are returned.

When the number of shards to be listed is greater than the value of
\code{MaxResults}, the response contains a \code{NextToken} value that you can use
in a subsequent call to \code{\link[=kinesis_list_shards]{list_shards}} to list the
next set of shards.}

\item{StreamCreationTimestamp}{Specify this input parameter to distinguish data streams that have the
same name. For example, if you create a data stream and then delete it,
and you later create another data stream with the same name, you can use
this input parameter to specify which of the two streams you want to
list the shards for.

You cannot specify this parameter if you specify the \code{NextToken}
parameter.}

\item{ShardFilter}{Enables you to filter out the response of the
\code{\link[=kinesis_list_shards]{list_shards}} API. You can only specify one
filter at a time.

If you use the \code{ShardFilter} parameter when invoking the ListShards API,
the \code{Type} is the required property and must be specified. If you
specify the \code{AT_TRIM_HORIZON}, \code{FROM_TRIM_HORIZON}, or \code{AT_LATEST}
types, you do not need to specify either the \code{ShardId} or the
\code{Timestamp} optional properties.

If you specify the \code{AFTER_SHARD_ID} type, you must also provide the
value for the optional \code{ShardId} property. The \code{ShardId} property is
identical in fuctionality to the \code{ExclusiveStartShardId} parameter of
the \code{\link[=kinesis_list_shards]{list_shards}} API. When \code{ShardId} property is
specified, the response includes the shards starting with the shard
whose ID immediately follows the \code{ShardId} that you provided.

If you specify the \code{AT_TIMESTAMP} or \code{FROM_TIMESTAMP_ID} type, you must
also provide the value for the optional \code{Timestamp} property. If you
specify the AT_TIMESTAMP type, then all shards that were open at the
provided timestamp are returned. If you specify the FROM_TIMESTAMP type,
then all shards starting from the provided timestamp to TIP are
returned.}

\item{StreamARN}{The ARN of the stream.}
}
\description{
Lists the shards in a stream and provides information about each shard. This operation has a limit of 1000 transactions per second per data stream.

See \url{https://www.paws-r-sdk.com/docs/kinesis_list_shards/} for full documentation.
}
\keyword{internal}
