% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_poll_for_task}
\alias{datapipeline_poll_for_task}
\title{Task runners call PollForTask to receive a task to perform from AWS Data
Pipeline}
\usage{
datapipeline_poll_for_task(workerGroup, hostname, instanceIdentity)
}
\arguments{
\item{workerGroup}{[required] The type of task the task runner is configured to accept and process.
The worker group is set as a field on objects in the pipeline when they
are created. You can only specify a single value for \code{workerGroup} in
the call to \code{PollForTask}. There are no wildcard values permitted in
\code{workerGroup}; the string must be an exact, case-sensitive, match.}

\item{hostname}{The public DNS name of the calling task runner.}

\item{instanceIdentity}{Identity information for the EC2 instance that is hosting the task
runner. You can get this value from the instance using
\verb{http://169.254.169.254/latest/meta-data/instance-id}. For more
information, see \href{http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html}{Instance Metadata}
in the \emph{Amazon Elastic Compute Cloud User Guide.} Passing in this value
proves that your task runner is running on an EC2 instance, and ensures
the proper AWS Data Pipeline service charges are applied to your
pipeline.}
}
\description{
Task runners call \code{PollForTask} to receive a task to perform from AWS
Data Pipeline. The task runner specifies which tasks it can perform by
setting a value for the \code{workerGroup} parameter. The task returned can
come from any of the pipelines that match the \code{workerGroup} value passed
in by the task runner and that was launched using the IAM user
credentials specified by the task runner.
}
\details{
If tasks are ready in the work queue, \code{PollForTask} returns a response
immediately. If no tasks are available in the queue, \code{PollForTask} uses
long-polling and holds on to a poll connection for up to a 90 seconds,
during which time the first newly scheduled task is handed to the task
runner. To accomodate this, set the socket timeout in your task runner
to 90 seconds. The task runner should not call \code{PollForTask} again on
the same \code{workerGroup} until it receives a response, and this can take
up to 90 seconds.
}
\section{Request syntax}{
\preformatted{svc$poll_for_task(
  workerGroup = "string",
  hostname = "string",
  instanceIdentity = list(
    document = "string",
    signature = "string"
  )
)
}
}

\keyword{internal}
