% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_security_configuration}
\alias{glue_create_security_configuration}
\title{Creates a new security configuration}
\usage{
glue_create_security_configuration(Name, EncryptionConfiguration)
}
\arguments{
\item{Name}{[required] The name for the new security configuration.}

\item{EncryptionConfiguration}{[required] The encryption configuration for the new security configuration.}
}
\description{
Creates a new security configuration.
}
\section{Request syntax}{
\preformatted{svc$create_security_configuration(
  Name = "string",
  EncryptionConfiguration = list(
    S3Encryption = list(
      list(
        S3EncryptionMode = "DISABLED"|"SSE-KMS"|"SSE-S3",
        KmsKeyArn = "string"
      )
    ),
    CloudWatchEncryption = list(
      CloudWatchEncryptionMode = "DISABLED"|"SSE-KMS",
      KmsKeyArn = "string"
    ),
    JobBookmarksEncryption = list(
      JobBookmarksEncryptionMode = "DISABLED"|"CSE-KMS",
      KmsKeyArn = "string"
    )
  )
)
}
}

\keyword{internal}
