% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_schema_versions_diff}
\alias{glue_get_schema_versions_diff}
\title{Fetches the schema version difference in the specified difference type
between two stored schema versions in the Schema Registry}
\usage{
glue_get_schema_versions_diff(SchemaId, FirstSchemaVersionNumber,
  SecondSchemaVersionNumber, SchemaDiffType)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure to contain schema identity fields. The
structure contains:
\itemize{
\item SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
One of \code{SchemaArn} or \code{SchemaName} has to be provided.
\item SchemaId$SchemaName: The name of the schema. One of \code{SchemaArn} or
\code{SchemaName} has to be provided.
}}

\item{FirstSchemaVersionNumber}{[required] The first of the two schema versions to be compared.}

\item{SecondSchemaVersionNumber}{[required] The second of the two schema versions to be compared.}

\item{SchemaDiffType}{[required] Refers to \code{SYNTAX_DIFF}, which is the currently supported diff type.}
}
\value{
A list with the following syntax:\preformatted{list(
  Diff = "string"
)
}
}
\description{
Fetches the schema version difference in the specified difference type
between two stored schema versions in the Schema Registry.

This API allows you to compare two schema versions between two schema
definitions under the same schema.
}
\section{Request syntax}{
\preformatted{svc$get_schema_versions_diff(
  SchemaId = list(
    SchemaArn = "string",
    SchemaName = "string",
    RegistryName = "string"
  ),
  FirstSchemaVersionNumber = list(
    LatestVersion = TRUE|FALSE,
    VersionNumber = 123
  ),
  SecondSchemaVersionNumber = list(
    LatestVersion = TRUE|FALSE,
    VersionNumber = 123
  ),
  SchemaDiffType = "SYNTAX_DIFF"
)
}
}

\keyword{internal}
