% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rspec.R
\name{summary.rspec}
\alias{summary.rspec}
\title{Colorimetric variables}
\usage{
\method{summary}{rspec}(object, subset = FALSE, wlmin = NULL,
  wlmax = NULL, ...)
}
\arguments{
\item{object}{(required) a data frame, possibly an object of class \code{rspec},
with a column with wavelength data, named 'wl', and the remaining column containing
spectra to process.}

\item{subset}{Either \code{FALSE} (the default), \code{TRUE}, or a character vector. 
If \code{FALSE}, all variables calculated are returned. If \code{TRUE}, only a subset 
of the complete ouput (composed of B2, S8 and H1; the variables described in 
Andersson and Prager 2006) are returned. Finally, a user-specified string of variable 
names can be used in order to filter and show only those variables.}

\item{wlmin, wlmax}{minimum and maximum used to define the range of wavelengths used in
calculations (default is to use entire range in the \code{rspec} object).}

\item{...}{class consistency (ignored)}
}
\value{
A data frame containing either 23 or 5 (\code{subset = TRUE}) variables described 
in Montgomerie (2006) with spectra name as row names. 
The colorimetric variables calculated by this function are 
described in Montgomerie (2006) with corrections included in the README CLR
file from the May 2008 distribution of the CLR sofware. Authors should reference 
both this package,Montgomerie (2006), and the original reference(s).
Description and notes on the measures:

B1 (Total brightness): Sum of the relative reflectance over the entire spectral
range (area under the curve). Frequently used but should be discouraged because
values are difficult to compare across studies (B2 is preferred). REF 1-3, 7, 9-11,
13

B2 (Mean brightness): Mean relative reflectance over the entire spectral range.
This is prefered to B1 since values are easier to compare across studies. REF 4, 12

B3 (Intensity): Maximum relative reflectance (Reflectance at wavelength of maximum
reflectance). Note that may be sensitive to noise near the peak. REF 1, 5, 6

S1 (Chroma): Relative contribution of a spectral range to the total brightness (B1)
S1 is arbitrarily devided in 6 measures of chroma based on the wavelength ranges 
normally associated with specific hues. The values are calculated using the 
following ranges: S1U (UV, if applicable): lambda min-400nm; 
S1v (Violet) lambda min-415nm; S1B (Blue) 400nm-510nm; S1G (Green) 510nm-605nm;
S1Y (Yellow) 550nm-625nm; S1R (Red) 605nm-lambda max. REF 2, 7, 8, 11-13

S2 (Spectral saturation): Rmax/Rmin This measure is sensitive to spectral noise.
Proper interpretation of this value may be difficult for spectra with multiple
peaks in the range of interest. REF 1

S3 (Chroma): Reflectance over the Rmax +- 50nm range divided by B1. Values for peaks 
within 50nm of either the minimum or maximum range of the data will not be comparable 
since the area under the curve for the area of interest will not always 
be based on the same wavelength range. Therefore, S3 should be interpreted 
with caution for peaks in the UV or Red range. REF 11

S4 (Spectral purity): |bmaxneg| , calculated by approximating the derivative
of the spectral curve. As such, it is very sensitive to noise and should only
be considered when data is adequately smoothed. NAs are returned for curves which
do not, at any range of wavelength, decrease in intensity. Therefore, reflectance 
curves for brown and red surfaces, for example, should not generate a values. REF 1

S5 (Chroma): Similar in design to segment classification measures (see Montgomerie 2006
for details). REF 10

S6 (Contrast): Rmax - Rmin. Because it uses both Rmin and Rmax, this measure may be
sensitive to spectral noise. REF 5, 6

S7 (Spectral saturation): Relative reflectance between the area around the peak with
reflectance equal to or larger to half of that of the peak (an approximation to the
full-width at half maxima. See Montgomerie (2006) for details). Somewhat sensitive 
to noise and can be misleading when more than one maxima and/or minima are present.
REF 3, 9

S8 (Chroma): (Rmax - Rmin)/B2. Because it uses both Rmin and Rmax, this measure may be
sensitive to spectral noise. REF 3, 13

S9 (Carotenoid chroma): (R450 - R700)/R700. Should only be used when the color 
of the surface is clearly due to carotenoid pigmentation and R450 is lower than
R700. Could be sensitive to noise. REF 8

S10 (Peaky chroma): (Rmax - Rmin)/B2 x |bmaxneg|. Should be used with properly 
smoothed curves. REF 7

H1 (Peak wavelength, hue): Wavelength of maximum reflectance. May be sensitive to noise
and may be variable if there is more than one maxima. REF 1, 2, 4, 6, 7, 10-13

H2 (Hue): Wavelength at bmaxneg. Should be calculated using smoothed data. REF 2, 13

H3 (Hue): Wavelength at Rmid. Sensitive to noisy spectra and may be variable if there are
more than one maxima and minima. REF 3, 9, 13

H4 (Hue): Similar in design to segment classification measures see Montgomerie
(2006) for details. REF 10

H5 (Hue): Wavelength at bmax. Sensitive to noise and may be variable if there is
more than one maxima and minima. REF 5
}
\description{
Calculates all 23 colorimetric variables reviewed in 
Montgomerie (2006).
}
\note{
If minimum wavelength is over 400, UV chroma is not computed.

Variables which compute bmax and bmaxneg should be used with caution, for they
rely on smoothed curves to remove noise, which would otherwise result in spurious
results. Make sure chosen smoothing parameters are adequate.

Smoothing affects only B3, S2, S4, S6, S10, H2, and H5 calculation. All other 
variables can be reliably extracted using non-smoothed data.
}
\examples{
\dontrun{
data(sicalis)
summary(sicalis)
summary(sicalis, subset = TRUE)
summary(sicalis, subset = c('B1', 'H4'))
}

}
\references{
Montgomerie R. 2006. Analyzing colors. In Hill, G.E, and McGraw, K.J., eds. 
Bird Coloration. Volume 1 Mechanisms and measuremements. Harvard University Press, Cambridge, Massachusetts.

References describing variables:

1- Andersson, S. 1999. Morphology of uv reflectance in a whistling-thrush: Implications for the study
of structural colour signalling in birds. Journal of Avian Biology 30:193-204.

2- Andersson, S., J. Ornborg, and M. Andersson. 1998. Ultraviolet sexual dimorphism and assortative
mating in blue tits. Proceedings of the Royal Society B 265:445-450.

3- Andersson, S., S. Pryke, J. Ornborg, M. Lawes, and M. Andersson. 2002. Multiple receivers, multiple
ornaments, and a trade-off between agonistic and epigamic signaling in a widowbird. American
Naturalist 160:683-691.

4- Delhey, K., A. Johnsen, A. Peters, S. Andersson, and B. Kempenaers. 2003. Paternity analysis reveals
opposing selection pressures on crown coloration in the blue tit (parus caeruleus). Proceedings
of the Royal Society B 270:2057-2063.

5- Keyser, A. and G. Hill. 1999. Condition-dependent variation in the blue-ultraviolet coloration of a
structurally based plumage ornament. Proceedings of the Royal Society B 266:771-777.

6- Keyser, A.J. and G. Hill. 2000. Structurally based plumage coloration is an honest signal of quality in
male blue grosbeaks. Behavioural Ecology 11:202-209.

7- Ornborg, J., S. Andersson, S. Griffith, and B. Sheldon. 2002. Seasonal changes in a ultraviolet
structural colour signal in blue tits, parus caeruleus. Biological Journal of the Linnean Society
76:237-245.

8- Peters, A., A. Denk, K. Delhey, and B. Kempenaers. 2004. Carotenoid-based bill colour as an
indicator of immunocompetence and sperm performance in male mallards. Journal of
Evolutionary Biology 17:1111-1120.

9- Pryke, S., M. Lawes, and S. Andersson. 2001. Agonistic carotenoid signalling in male red-collared
widowbirds: Aggression related to the colour signal of both the territory owner and model
intruder. Animal Behaviour 62:695-704.

10- Saks, L., K. Mcgraw, and P. Horak. 2003. How feather colour reflects its carotenoid content.
Functional Ecology 17:555-561.

11- Shawkey, M., A. Estes, L. Sieffereman, and G. Hill. 2003. Nanostructure predicts intraspecific
variation in ultraviolet-blue plumage colour. Proceedings of the Royal Society B
270:1455-1460.

12- Siefferman, L. and G. Hill. 2005. Uv-blue structural coloration and competition for nestboxes in male
eastern bluebirds. Animal Behaviour 69:67-72.

13- Smiseth, P., J. Ornborg, S. Andersson, and T. Amundsen. 2001. Is male plumage reflectance
correlated with paternal care in bluethroats? Behavioural Ecology 12:164-170.
}
\author{
Pierre-Paul Bitton \email{bittonp@windsor.ca}, Rafael Maia \email{rm72@zips.uakron.edu}
}
