% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{print.pc_matrix}
\alias{print.pc_matrix}
\title{Print Pattern Causality Matrix}
\usage{
\method{print}{pc_matrix}(x, type = "all", ...)
}
\arguments{
\item{x}{A \code{pc_matrix} object.}

\item{type}{The type of matrix to print ("all" or "positive", "negative", "dark").}

\item{...}{Additional arguments passed to the \code{print} function.}
}
\value{
Invisibly returns the input object.
}
\description{
Prints the pattern causality matrix object.
This function displays the specified causality matrix (or all matrices)
with a preview of the first 5 rows and columns.
}
\examples{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1, 
  metric = "euclidean", h = 1, weighted = TRUE, 
  verbose = FALSE)
print(pc_matrix_obj, type = "positive")
}
