% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatureSpace.R
\name{signatureSpace}
\alias{signatureSpace}
\title{Create Signature Space from Embedded Matrix}
\usage{
signatureSpace(M, E)
}
\arguments{
\item{M}{Matrix, the embedded state space matrix where each row is a point in the reconstructed state space of the time series.}

\item{E}{Integer, the embedding dimension used to create the matrix M.}
}
\value{
Matrix where each row represents the vector of differences between successive elements of the corresponding row in matrix M. The orientation of the matrix may vary depending on the embedding dimension.
}
\description{
This function computes the signature space of a matrix obtained from a time series' state space by calculating the successive differences of each embedded vector. The signature space reveals changes between successive points in the time series, capturing dynamics that are crucial for understanding complex system behaviors.
}
\examples{
data(climate)
ts <- climate$AO
E <- 3
tau <- 1
stateSpaceMatrix <- stateSpace(ts, E, tau)
signatureMatrix <- signatureSpace(stateSpaceMatrix, E)
print(signatureMatrix)
}
