% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillPCMatrix.R
\name{fillPCMatrix}
\alias{fillPCMatrix}
\title{Calculate and Record Causality Strengths}
\usage{
fillPCMatrix(
  weighted,
  predictedPatternY,
  realPatternY,
  predictedSignatureY,
  realSignatureY,
  patternX,
  signatureX
)
}
\arguments{
\item{weighted}{Logical, if TRUE, the causality strength is calculated using the error function for normalization,
otherwise a binary indication (1 for accurate prediction and 0 otherwise) is used.}

\item{predictedPatternY}{Numeric vector, the predicted pattern of variable Y at a future time step.}

\item{realPatternY}{Numeric vector, the actual observed pattern of variable Y at the same future time step.}

\item{predictedSignatureY}{Numeric vector, the predicted signature vector derived from the system model for Y.}

\item{realSignatureY}{Numeric vector, the actual observed signature vector for Y.}

\item{patternX}{Numeric vector, the current observed pattern of variable X, used as the basis for prediction.}

\item{signatureX}{Numeric vector, the current observed signature vector of variable X.}
}
\value{
A dataframe with two columns: 'real' and 'predicted', representing the real and predicted causality strengths.
}
\description{
Computes the causality strengths based on the comparison between predicted and real patterns
and signatures in a system's dynamic model. It applies a normalization function to measure the intensity of
causal influences and uses an error function for weighting if required.
}
\details{
Fill Pattern Causality Matrix with Causality Strengths

This function calculates and fills the causality strengths between predicted and real patterns and signatures
for a complex system analysis. It evaluates the accuracy of predictions and computes the strength of causal
relationships based on norm vectors and optionally weights these strengths using the error function (erf).
}
\examples{
set.seed(123)
E <- 3
tau <- 1
Mx <- matrix(rnorm(200), nrow = 20)
My <- matrix(rnorm(200), nrow = 20)
Dx <- distanceMatrix(Mx, "minkowski")
Dy <- distanceMatrix(My, "minkowski")
SMx <- signatureSpace(Mx, E)
SMy <- signatureSpace(My, E)
PSMx <- patternSpace(SMx, E)
PSMy <- patternSpace(SMy, E)
CCSPAN <- (E - 1) * tau
NNSPAN <- E + 1
i <- 15
h <- 2
NNx <- pastNNsInfo(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
timesX <- NNx$times
projNNy <- projectedNNsInfo(My, Dy, SMy, PSMy, timesX, i, h)
pSY <- predictionY(E, projNNy, zeroTolerance = E - 1)$predictedSignatureY
pPY <- predictionY(E, projNNy, zeroTolerance = E - 1)$predictedPatternY[1]
rSY <- SMy[(i + h), ]
rPY <- PSMy[i + h]
signatureX <- SMx[i, ]
patternX <- PSMx[i, ]
weighted <- 0
pc <- fillPCMatrix(weighted, pPY, rPY, pSY, rSY, patternX, signatureX)
}
