% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/paths.R
\name{system_file}
\alias{system_file}
\title{Find a file in a package}
\usage{
system_file(..., package = "base", library_location = NULL,
  must_work = FALSE, sep = c("/", "\\\\"))
}
\arguments{
\item{...}{Character vectors specifying subdirectories and files within some
package. The default, none, returns the root of the package. Wildcards are
not supported.}

\item{package}{A string with the name of a single package. An error occurs if
more than one package name is given.}

\item{library_location}{a character vector with path names of R libraries.
See the 'Details section of \code{\link[base]{system.file}} for the meaning
of the default value of NULL.}

\item{must_work}{If \code{TRUE}, an error is given if there are no matching
files.}

\item{sep}{String separator between directory levels in the output.}
}
\value{
A character vector of positive length, containing the file paths that
matched \code{...}, or a missing string, \code{NA}, if none matched (unless
\code{mustWork = TRUE}).  (This behaviour for missing paths differs from
\code{system.file}.)
If matching the root of a package, there is no trailing separator.
system.file() with no arguments gives the root of the base package.
}
\description{
Wrapper to \code{system.file} that returns standardized paths.
}
\examples{
# Examples taken from ?system.file
system_file()                  # The root of the 'base' package
system_file(package = "stats") # The root of package 'stats'
system_file("INDEX")
system_file("help", "AnIndex", package = "splines")
}
\seealso{
\code{\link[base]{system.file}}
}

