\name{patchSynctex-package}
\alias{patchSynctex-package}
\docType{package}
\title{
Allows for communication between .Rnw editor and .pdf viewer.
}
\description{
  
Utility patching the .synctec(.gz) file resulting from then
\code{LaTeX}ing of a .tex file with the concordance information from the
.concordance.tex file resulting from knitting (possibly Sweaving) of the
.Rnw source, allowing(for|back)ward searching from the editor to the viewer and back.
}

\details{

  Synchronising TeX source and DVI/PDF output considerably eases
  the editing (and, sometimes, debugging) of such documents, by allowing
  interaction between source and end-result. Modern DVI/PDF viewers and
  editors support this synchronization, either directly, by using
  information embedded in the \code{.dvi} or \code{.pdf} file, or by
  using an auxilliary file generated by a LaTeX run with option
  \code{\\synctex=1}, teh \code{.synctex(.gz)} file.

  However, when one uses a tool such as \code{Sweave} or \code{knitr} to
generate a dynamic document (compounding analysis, computations and
report), the resulting \code{.tex} file is no longer the original
source, and the references to the \code{.tex} file are of little help in
the revision of such a document.

Duncan Murdoch's \strong{patchDVI} package aims at solving this problem
by using a \emph{concordance} file that can be generated by passing a
\code{concordance=TRUE} option so \code{Sweave} or \code{knit*}. This
\code{-concordance.tex} file contains an RLE encoding of the
correspondence between the \code{.Rnw} source and the \code{.tex}
intermediary file.

\strong{patchDVI} uses this concordance information to patch the DVI
pointers to source with the relevant pointers to the \code{.Rnw} file.

This package also has a \code{patchSynctex} function, attempting t find
the relevant information in the \code{.pdf} file. However, some (most ?)
PDFs happens to be impenetrable to \strong{patchDVI}'s
\code{patchSynctex} function.

The present package aims at patching the \code{.synctex(.gz)} file with
pointers to the original \code{.Rnw} source(s), using exclusively the
\code{.synctex(.gz)} file as a source of information. Therefore, the
tools (editors and viewers) must support Synctex in such a way that,
when a \code{.synctex(.gz)} file is present, this information is
preffered to the information present in the DVI or PDF document.

This turns out, according to some serious googling and limited testing,
to be the case with :

\itemize{
  \item under Linux: \code{emacs}, \code{gedit} (editors),
  \code{evince}, \code{okular} (viewers), \code{RStudio} (IDE);
  \item under MS-Windows: \code{emacs} (editor), \code{Sumatra}
  (viewer), \code{RStudio} (IDE).
  %% TODO : Mac OS X
}

Furthermore, the \code{.synctex(.gz)} file file remains necessary for
any synchronization, whereas a patched \code{.dvi} file can in principle
be used without the \code{.synctex(.gz)} file.

This package is mostly aimed at \strong{programs} (integrated
development environments (IDEs), such as \code{RStudio}, or programmable
editors, such as \code{emacs} and \code{gedit}) able to get R to execute
code: it gives them an easy-to-use interface to a simple function does
the ncessary patches for a given document (characterized by its name
sans extension).

Its unique function can still be used from an interactive R session for
debugging purposes.
}

\section{Integration in editors and IDEs}{
  \emph{This section will be enriched by \strong{your} contributions.}
  \subsection{\code{ESS} under \code{emacs}}{
    The logical point of insertion of \code{.synctex(.gz)} patching is
    after each PDF compilation. It may be a bit wasteful (when two or
    more compilations are necessary, in order, for example, to fix
    references), but there is no standard way to determine if a LaTeX run
    is final.

    This can be achieved by placing an advice on the function used to
    compile to PDF|DVI. The example shows how to advice PDF compilation.
    
    \subsection{Up to \code{emacs} 24.3}{
      The following \code{elisp} snippet can be placed in your
      \code{emacs} initialization file (e. g. \code{~/.emacs} in
      Unix(-like) systems): 
      \preformatted{
(defadvice ess-swv-PDF (after ess-run-patchKnitr (&optional
						  PDFLATEX-CMD)
			      activate)
  "Patches the .synctex.gz file after PDF compilation"
  (interactive)
  (let* ((fn (buffer-file-name))
	 (fe (file-name-extension fn)))
    (if (string= fe "Rnw")
	(progn
	  (setq RPScmd (concat "patchSynctex('"
			       (file-name-sans-extension fn)
			       "')"))
	  (ess-create-temp-buffer "tampon-ess-execute")
	  (ess-execute "require(patchSynctex)" 'buffer "tampon-ess-execute")
	  (ess-execute RPScmd 'buffer "tampon-ess-execute")
	  (kill-buffer "tampon-ess-execute")))))
(ad-activate 'ess-swv-PDF)
      }
    }
    
    \subsection{From \code{emacs} 24.4 onwards}{
      The previous \code{elisp} snippet has to be adapted to the newer
      \code{advice} system of \code{elisp}:
      \preformatted{

(defun ess-swv-patch-after-PDF (&optional PDFLATEX-CMD)
  "Patch the synctex file after PDF compilation"
  (let* ((fn (buffer-file-name))
	 (fe (file-name-extension fn)))
    (if (string= fe "Rnw")
	(progn
	  (setq RPScmd (concat "patchSynctex('"
			       (file-name-sans-extension fn)
			       "')"))
	  (ess-create-temp-buffer "tampon-ess-execute")
	  (ess-execute "require(patchSynctex)" 'buffer "tampon-ess-execute")
	  (ess-execute RPScmd 'buffer "tampon-ess-execute")
	  (kill-buffer "tampon-ess-execute")))))
(advice-add 'ess-swv-PDF :after #'ess-swv-patch-after-PDF)
      }
    }
  }
  \subsection{\code{AUCTeX} under \code{emacs}}{

    This is a work in progress : \code{AUCTeX} is more sophisticated
  than \code{ESS} about PDF production. There is no single function to
  advice (and \code{knit}ting is not yet well integrated, by the
  way...). In the meantime, \code{ESS} functions remain
  available. \emph{Stay tuned...}
  
  }
  \subsection{Eclipse + StatET}{
   Create an external build configuration (Sweave document processing)
  and place :
  \preformatted{
require(knitr); 
opts_knit$set(concordance = TRUE); 
texfile <- knit("${resource_loc:${source_file_path}}", encoding="UTF-8")
    }
    in the \code{sweave} tab, and :
    \preformatted{
syntex <- if (opts_knit$get('concordance'))"-synctex=1" else "-synctex=0";
command=paste("latexmk -pdf", syntex, "-interaction=nonstopmode", shQuote(texfile));
print(paste("Command ",command,"...\n"));
print(shell(command),intern = TRUE);
if (opts_knit$get('concordance'))\{
    require(patchSynctex);
    patchSynctex(texfile); 
\}
print(paste0(substr(texfile,1, nchar(texfile)-3), "pdf"))
      }
      in the \code{LaTeX} tab.
    }
  }

\author{Jan Gleixner, Emmanuel Charpentier

Maintainer: Emmanuel Charpentier \url{emm.charpentier@free.fr} }

\note{ The current (1.8) version of \code{knitr} does not yet implement
concordance for multifile projects (i. e. children chunks). }

\references{

  Duncan Murdoch's
\href{http://cran.r-project.org/package=patchDVI}{patchDVI}
has a great vignette explaining the basics of the problem :
\url{http://cran.r-project.org/web/packages/patchDVI/patchDVI.pdf}

}
%% ~~ Optionally other standard keywords, one per line, from file KEYWORDS in ~~
%% ~~ the R documentation directory ~~
%% \keyword{ package }
%% \seealso{
%% ~~ Optional links to other man pages, e.g. ~~
%% ~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%% }
%% \examples{
%% ~~ simple examples of the most important functions ~~
%% }
