% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{mcconnaughey}
\alias{mcconnaughey}
\alias{mcconnaughey,Partition,Partition-method}
\alias{mcconnaughey,PairCoefficients,missing-method}
\title{McConnaughey Index}
\usage{
mcconnaughey(p, q)

\S4method{mcconnaughey}{Partition,Partition}(p, q)

\S4method{mcconnaughey}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the McConnaughey index
\deqn{\frac{N_{11}^2 - N_{10}N_{01}}{N_{21}N_{12}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(mcconnaughey(new("Partition", c(0, 0, 0, 1, 1)), 
                              new("Partition", c(0, 0, 1, 1, 1))), 0))

}
\references{
\insertRef{McConnaughey1964}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
