% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree_xgboost.R
\name{details_boost_tree_xgboost}
\alias{details_boost_tree_xgboost}
\title{Boosted trees via xgboost}
\description{
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} creates a series of decision trees forming an
ensemble. Each tree depends on the results of previous trees. All trees in
the ensemble are combined to produce a final prediction.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 8 tuning parameters:
\itemize{
\item \code{tree_depth}: Tree Depth (type: integer, default: 6L)
\item \code{trees}: # Trees (type: integer, default: 15L)
\item \code{learn_rate}: Learning Rate (type: double, default: 0.3)
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{min_n}: Minimal Node Size (type: integer, default: 1L)
\item \code{loss_reduction}: Minimum Loss Reduction (type: double, default:
0.0)
\item \code{sample_size}: Proportion Observations Sampled (type: double,
default: 1.0)
\item \code{stop_iter}: # Iterations Before Stopping (type: integer, default:
Inf)
}

The \code{mtry} parameter is related to the number of predictors. The default
is to use all predictors. \code{\link[xgboost:xgb.train]{xgboost::xgb.train()}}
encodes this as a real number between zero and one. parsnip translates
the number of columns to this type of value. The user should give the
argument to \code{boost_tree()} as an integer (not a real number).
}

\subsection{Translation from parsnip to the original package (regression)}{\if{html}{\out{<div class="r">}}\preformatted{boost_tree(
  mtry = integer(), trees = integer(), min_n = integer(), tree_depth = integer(),
  learn_rate = numeric(), loss_reduction = numeric(), sample_size = numeric(),
  stop_iter = integer()
) \%>\%
  set_engine("xgboost") \%>\%
  set_mode("regression") \%>\%
  translate()
}\if{html}{\out{</div>}}\preformatted{## Boosted Tree Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer()
##   trees = integer()
##   min_n = integer()
##   tree_depth = integer()
##   learn_rate = numeric()
##   loss_reduction = numeric()
##   sample_size = numeric()
##   stop_iter = integer()
## 
## Computational engine: xgboost 
## 
## Model fit template:
## parsnip::xgb_train(x = missing_arg(), y = missing_arg(), colsample_bynode = integer(), 
##     nrounds = integer(), min_child_weight = integer(), max_depth = integer(), 
##     eta = numeric(), gamma = numeric(), subsample = numeric(), 
##     early_stop = integer(), nthread = 1, verbose = 0)
}
}

\subsection{Translation from parsnip to the original package (classification)}{\if{html}{\out{<div class="r">}}\preformatted{boost_tree(
  mtry = integer(), trees = integer(), min_n = integer(), tree_depth = integer(),
  learn_rate = numeric(), loss_reduction = numeric(), sample_size = numeric(),
  stop_iter = integer()
) \%>\% 
  set_engine("xgboost") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Boosted Tree Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer()
##   trees = integer()
##   min_n = integer()
##   tree_depth = integer()
##   learn_rate = numeric()
##   loss_reduction = numeric()
##   sample_size = numeric()
##   stop_iter = integer()
## 
## Computational engine: xgboost 
## 
## Model fit template:
## parsnip::xgb_train(x = missing_arg(), y = missing_arg(), colsample_bynode = integer(), 
##     nrounds = integer(), min_child_weight = integer(), max_depth = integer(), 
##     eta = numeric(), gamma = numeric(), subsample = numeric(), 
##     early_stop = integer(), nthread = 1, verbose = 0)
}

\code{\link[=xgb_train]{xgb_train()}} is a wrapper around
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} (and other functions)
that makes it easier to run this model.
}

\subsection{Preprocessing requirements}{

xgboost does not have a means to translate factor predictors to grouped
splits. Factor/categorical predictors need to be converted to numeric
values (e.g., dummy or indicator variables) for this engine. When using
the formula method via \code{\link[=fit.model_spec]{fit.model_spec()}}, parsnip
will convert factor columns to indicators using a one-hot encoding.

For classification, non-numeric outcomes (i.e., factors) are internally
converted to numeric. For binary classification, the \code{event_level}
argument of \code{set_engine()} can be set to either \code{"first"} or \code{"second"}
to specify which level should be used as the event. This can be helpful
when a watchlist is used to monitor performance from with the xgboost
training process.
}

\subsection{Other details}{
\subsection{Sparse matrices}{

xgboost requires the data to be in a sparse format. If your predictor
data are already in this format, then use
\code{\link[=fit_xy.model_spec]{fit_xy.model_spec()}} to pass it to the model
function. Otherwise, parsnip converts the data to this format.
}

\subsection{Parallel processing}{

By default, the model is trained without parallel processing. This can
be change by passing the \code{nthread} parameter to
\code{\link[=set_engine]{set_engine()}}. However, it is unwise to combine this
with external parallel processing when using the package.
}

\subsection{Early stopping}{

The \code{stop_iter()} argument allows the model to prematurely stop training
if the objective function does not improve within \code{early_stop}
iterations.

The best way to use this feature is in conjunction with an \emph{internal
validation set}. To do this, pass the \code{validation} parameter of
\code{\link[=xgb_train]{xgb_train()}} via the parsnip
\code{\link[=set_engine]{set_engine()}} function. This is the proportion of the
training set that should be reserved for measuring performance (and stop
early).

If the model specification has \code{early_stop >= trees}, \code{early_stop} is
converted to \code{trees - 1} and a warning is issued.
}

\subsection{Objective function}{

parsnip chooses the objective function based on the characteristics of
the outcome. To use a different loss, pass the \code{objective} argument to
\code{\link[=set_engine]{set_engine()}}.
}

}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#boost-tree-xgboost}{examples}
for \code{boost_tree()} with the \code{"xgboost"} engine.
}

\subsection{References}{
\itemize{
\item \href{https://arxiv.org/abs/1603.02754}{XGBoost: A Scalable Tree Boosting System}
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
