% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree.R, R/decision_tree.R,
%   R/linear_reg.R, R/logistic_reg.R, R/mars.R, R/mlp.R, R/multinom_reg.R,
%   R/nearest_neighbor.R, R/proportional_hazards.R, R/rand_forest.R,
%   R/surv_reg.R, R/survival_reg.R, R/svm_linear.R, R/svm_poly.R, R/svm_rbf.R,
%   R/update.R
\name{update.boost_tree}
\alias{update.boost_tree}
\alias{update.decision_tree}
\alias{update.linear_reg}
\alias{update.logistic_reg}
\alias{update.mars}
\alias{update.mlp}
\alias{update.multinom_reg}
\alias{update.nearest_neighbor}
\alias{update.proportional_hazards}
\alias{update.rand_forest}
\alias{update.surv_reg}
\alias{update.survival_reg}
\alias{update.svm_linear}
\alias{update.svm_poly}
\alias{update.svm_rbf}
\alias{parsnip_update}
\title{Update a model specification}
\usage{
\method{update}{boost_tree}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  stop_iter = NULL,
  fresh = FALSE,
  ...
)

\method{update}{decision_tree}(
  object,
  parameters = NULL,
  cost_complexity = NULL,
  tree_depth = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)

\method{update}{linear_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{logistic_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{mars}(
  object,
  parameters = NULL,
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{mlp}(
  object,
  parameters = NULL,
  hidden_units = NULL,
  penalty = NULL,
  dropout = NULL,
  epochs = NULL,
  activation = NULL,
  fresh = FALSE,
  ...
)

\method{update}{multinom_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{nearest_neighbor}(
  object,
  parameters = NULL,
  neighbors = NULL,
  weight_func = NULL,
  dist_power = NULL,
  fresh = FALSE,
  ...
)

\method{update}{proportional_hazards}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{rand_forest}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)

\method{update}{surv_reg}(object, parameters = NULL, dist = NULL, fresh = FALSE, ...)

\method{update}{survival_reg}(object, parameters = NULL, dist = NULL, fresh = FALSE, ...)

\method{update}{svm_linear}(
  object,
  parameters = NULL,
  cost = NULL,
  margin = NULL,
  fresh = FALSE,
  ...
)

\method{update}{svm_poly}(
  object,
  parameters = NULL,
  cost = NULL,
  degree = NULL,
  scale_factor = NULL,
  margin = NULL,
  fresh = FALSE,
  ...
)

\method{update}{svm_rbf}(
  object,
  parameters = NULL,
  cost = NULL,
  rbf_sigma = NULL,
  margin = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{object}{A model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. Use \strong{either} \code{parameters} \strong{or} the main arguments
directly when updating. If the main arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{mtry}{A number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models (\code{xgboost}
only).}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that is required for the node to be split further.}

\item{tree_depth}{An integer for the maximum depth of the tree (i.e. number
of splits) (\code{xgboost} only).}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration (\code{xgboost} only).}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further (\code{xgboost} only).}

\item{sample_size}{A number for the number (or proportion) of data that is
exposed to the fitting routine. For \code{xgboost}, the sampling is done at
each iteration while \code{C5.0} samples once during training.}

\item{stop_iter}{The number of iterations without improvement before
stopping (\code{xgboost} only).}

\item{fresh}{A logical for whether the arguments should be
modified in-place or replaced wholesale.}

\item{...}{Not used for \code{update()}.}

\item{cost_complexity}{A positive number for the the cost/complexity
parameter (a.k.a. \code{Cp}) used by CART models (\code{rpart} only).}

\item{penalty}{A non-negative number representing the total
amount of regularization (\code{glmnet}, \code{keras}, and \code{spark} only).
For \code{keras} models, this corresponds to purely L2 regularization
(aka weight decay) while the other models can be a combination
of L1 and L2 (depending on the value of \code{mixture}; see below).}

\item{mixture}{A number between zero and one (inclusive) that is the
proportion of L1 regularization (i.e. lasso) in the model. When
\code{mixture = 1}, it is a pure lasso model while \code{mixture = 0} indicates that
ridge regression is being used. (\code{glmnet} and \code{spark} only).}

\item{num_terms}{The number of features that will be retained in the
final model, including the intercept.}

\item{prod_degree}{The highest possible interaction degree.}

\item{prune_method}{The pruning method.}

\item{hidden_units}{An integer for the number of units in the hidden model.}

\item{dropout}{A number between 0 (inclusive) and 1 denoting the proportion
of model parameters randomly set to zero during model training.}

\item{epochs}{An integer for the number of training iterations.}

\item{activation}{A single character string denoting the type of relationship
between the original predictors and the hidden unit layer. The activation
function between the hidden and output layers is automatically set to either
"linear" or "softmax" depending on the type of outcome. Possible values are:
"linear", "softmax", "relu", and "elu"}

\item{neighbors}{A single integer for the number of neighbors
to consider (often called \code{k}). For \pkg{kknn}, a value of 5
is used if \code{neighbors} is not specified.}

\item{weight_func}{A \emph{single} character for the type of kernel function used
to weight distances between samples. Valid choices are: \code{"rectangular"},
\code{"triangular"}, \code{"epanechnikov"}, \code{"biweight"}, \code{"triweight"},
\code{"cos"}, \code{"inv"}, \code{"gaussian"}, \code{"rank"}, or \code{"optimal"}.}

\item{dist_power}{A single number for the parameter used in
calculating Minkowski distance.}

\item{dist}{A character string for the outcome distribution. "weibull" is
the default.}

\item{cost}{A positive number for the cost of predicting a sample within
or on the wrong side of the margin}

\item{margin}{A positive number for the epsilon in the SVM insensitive
loss function (regression only)}

\item{degree}{A positive number for polynomial degree.}

\item{scale_factor}{A positive number for the polynomial scaling factor.}

\item{rbf_sigma}{A positive number for radial basis function.}
}
\value{
An updated model specification.
}
\description{
If parameters of a model specification need to be modified, \code{update()} can
be used in lieu of recreating the object from scratch.
}
\examples{
model <- boost_tree(mtry = 10, min_n = 3)
model
update(model, mtry = 1)
update(model, mtry = 1, fresh = TRUE)

param_values <- tibble::tibble(mtry = 10, tree_depth = 5)

model \%>\% update(param_values)
model \%>\% update(param_values, mtry = 3)

param_values$verbose <- 0
# Fails due to engine argument
# model \%>\% update(param_values)

model <- linear_reg(penalty = 10, mixture = 0.1)
model
update(model, penalty = 1)
update(model, penalty = 1, fresh = TRUE)

}
