% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_template.R
\name{rmd_template}
\alias{rmd_template}
\title{Create a template from an \code{rmd} object.}
\usage{
rmd_template(
  rmd,
  keep_content = FALSE,
  keep_labels = TRUE,
  keep_headings = FALSE,
  keep_yaml = FALSE,
  ...
)
}
\arguments{
\item{rmd}{R Markdown document in the form of an \code{rmd_ast} or \code{rmd_tibble}.}

\item{keep_content}{Should the template keep the document's content (markdown text and chunk code).}

\item{keep_labels}{Should the template keep the document's code chunk labels.}

\item{keep_headings}{Should the template keep the document's headings.}

\item{keep_yaml}{Should the template keep the document's yaml.}

\item{...}{Unused, for extensibility.}
}
\value{
Returns an \code{rmd_template} object, which is a derived tibble containing relevant structural
details of the document.
}
\description{
Templates are objects which are meant to capture the structure of an R Markdown document and facilitate the
comparison between the template and new Rmd documents, usually to ensure the structure and/or content matches
sufficiently.
}
\examples{
rmd = parse_rmd(system.file("hw01.Rmd", package="parsermd"))

rmd_select(rmd, by_section(c("Exercise *", "Solution"))) \%>\%
  rmd_template()
}
