% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_string.R
\name{by_symbol}
\alias{by_symbol}
\title{Applying a parser to individual symbols of a string}
\usage{
by_symbol(p, finish = TRUE)
}
\arguments{
\item{p}{A parser.}

\item{finish}{logical. Should the parser completely consume the string?
Defaults to \code{TRUE}.}
}
\value{
A parser.
}
\description{
Splits a string to individual symbols and then applies the parser \code{p} to the
resulting character vector, otherwise the parser fails. If \code{finish = TRUE}
then the parser should completely consume its input. If \code{finish = FALSE}
then any remaining part of the string is discarded.

This function is identical to \code{by_split(p, "", finish)}.
}
\examples{
by_symbol(exactly(3,literal("a"))) (c("aaa", "bb")) # success
by_symbol(exactly(3,literal("a"))) (c("aaaa", "bb")) # failure
}
\seealso{
\code{\link[=by_split]{by_split()}}
}
