% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcats.R
\name{parcats}
\alias{parcats}
\title{create plotly parallel categories diagram from alluvial plot}
\usage{
parcats(
  p,
  marginal_histograms = TRUE,
  data_input = NULL,
  imp = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL,
  hoveron = "color",
  hoverinfo = "count+probability",
  arrangement = "perpendicular",
  bundlecolors = TRUE,
  sortpaths = "forward",
  labelfont = list(size = 24, color = "black"),
  tickfont = NULL,
  offset_marginal_histograms = 0.8,
  offset_imp = 0.9
)
}
\arguments{
\item{p}{alluvial plot}

\item{marginal_histograms}{logical, add marginal histograms, Default: TRUE}

\item{data_input}{dataframe, data used to create alluvial plot, Default: NULL}

\item{imp}{dataframe, with not more then two columns one of them numeric
containing importance measures and one character or factor column containing
corresponding variable names as found in training data.}

\item{width}{integer, htmlwidget width in pixels, Default: NULL}

\item{height}{integer, htmlwidget height in pixels, Default: NULL}

\item{elementId}{, htmlwidget elementid, Default: NULL}

\item{hoveron}{character, one of c('category', 'color', 'dimension'), Sets the
hover interaction mode for the parcats diagram.', 'If `category`, hover
interaction take place per category.', 'If `color`, hover interactions take
place per color per category.', 'If `dimension`, hover interactions take
place across all categories per dimension., Default: 'color'}

\item{hoverinfo}{character, one of c('count', 'probability',
'count+probability') set info displayed on mouse hover Default:
'count+probability'}

\item{arrangement, }{character, one of c('perpendicular', 'freeform', 'fixed')
'Sets the drag interaction mode for categories and dimensions.', 'If
`perpendicular`, the categories can only move along a line perpendicular to
the paths.', 'If `freeform`, the categories can freely move on the plane.',
'If `fixed`, the categories and dimensions are stationary.', Default:
'perpendicular'}

\item{bundlecolors}{logical, 'Sort paths so that like colors are bundled
together within each category.', Default: TRUE}

\item{sortpaths}{character, one of c('forward', 'backward'), 'Sets the path
sorting algorithm.', 'If `forward`, sort paths based on dimension categories
from left to right.', Default: 'forward' 'If `backward`, sort paths based on
dimensions categories from right to left.'}

\item{labelfont}{list, 'Sets the font for the `dimension` labels.', Default:
list(size = 24, color = 'black')}

\item{tickfont}{list, Sets the font for the `category` labels.', Default: NULL}

\item{offset_marginal_histograms}{double, height ratio reserved for parcats
diagram, Default: 0.8}

\item{offset_imp}{double, width ratio reserved for parcats diagram, Default:
0.9}
}
\value{
htmlwidget
}
\description{
creates an interactive parallel categories diagram from an 'easyalluvial'
 plot using the 'plotly.js' library
}
\details{
most parameters are best left at default values
}
\examples{

library(easyalluvial)

# alluvial wide ---------------------------------
p = alluvial_wide(mtcars2, max_variables = 5)

parcats(p, marginal_histograms = FALSE)

parcats(p, marginal_histograms = TRUE, data_input = mtcars2)

# alluvial for model response --------------------
df = mtcars2[, ! names(mtcars2) \%in\% 'ids' ]
m = randomForest::randomForest( disp ~ ., df)
imp = m$importance
dspace = get_data_space(df, imp, degree = 3)
pred = predict(m, newdata = dspace)
p = alluvial_model_response(pred, dspace, imp, degree = 3)

parcats(p, marginal_histograms = TRUE, imp = TRUE, data_input = df)


}
\seealso{
\code{\link[easyalluvial]{alluvial_wide}}
, \code{\link[easyalluvial]{alluvial_long}}
, \code{\link[easyalluvial]{alluvial_model_response}}
, \code{\link[easyalluvial]{alluvial_model_response_caret}}
}
