% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_table.R
\name{parameters_table}
\alias{parameters_table}
\title{Parameter table formatting}
\usage{
parameters_table(
  x,
  pretty_names = TRUE,
  stars = FALSE,
  digits = 2,
  ci_digits = 2,
  p_digits = 3,
  ...
)
}
\arguments{
\item{x}{A data frame of model's parameters.}

\item{pretty_names}{Pretty parameters' names.}

\item{stars}{Add significance stars (e.g., p < .001***).}

\item{digits}{Number of decimal places for numeric values (except confidence intervals and p-values).}

\item{ci_digits}{Number of decimal places for confidence intervals.}

\item{p_digits}{Number of decimal places for p-values. May also be \code{"scientific"} for scientific notation of p-values.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame.
}
\description{
Parameter table formatting
}
\examples{
library(parameters)

x <- model_parameters(lm(Sepal.Length ~ Species * Sepal.Width, data = iris))
as.data.frame(parameters_table(x))
as.data.frame(parameters_table(x, p_digits = "scientific"))
\donttest{
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, seed = 123)
  x <- model_parameters(model, ci = c(0.69, 0.89, 0.95))
  as.data.frame(parameters_table(x))
}
}
}
