% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_reduction.R
\name{parameters_reduction}
\alias{parameters_reduction}
\title{Dimensionality reduction (DR) / Features Reduction}
\usage{
parameters_reduction(x, method = "PCA", n = "max", ...)
}
\arguments{
\item{x}{A dataframe or a statistical model.}

\item{method}{The features reduction method. Can be one of 'PCA', 'cMDS', 'DRR', 'ICA' (see the Details section).}

\item{n}{Number of components to extract. If \code{n = "all"} =, then \code{n} is set as the number of variables minus 1 (\code{ncol(x)-1}). If \code{n = "auto"} (default) or \code{n = NULL}, the number of components is selected through \code{\link{n_factors}}. In \code{\link{parameters_reduction}}, can also be \code{"max"}, in which case it will select all the components that are maximally pseudo-loaded (i.e., correlated) by at least one variable.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
This function performs a reduction in the parameters space (the number of variables). It starts by creating a new set of variables, based on a given method (the default method is "PCA", but other are available via the \code{method} argument, such as "cMDS", "DRR" or "ICA"). Then, it names this new dimensions using the original variables that correlates the most with it. For instance, a variable named 'V1_0.97/V4_-0.88' means that the V1 and the V4 variables correlate maximally (with respective coefficients of .97 and -.88) with this dimension. Although this function can be useful in exploratory data analysis, it's best to perform the dimension reduction step in a separate and dedicated stage, as this is a very important process in the data analysis workflow.
}
\details{
The different methods available are described below:

\subsection{Supervised Methods}{
\itemize{
\item \strong{PCA}: See \code{\link{principal_components}}.
}

\itemize{
\item \strong{cMDS / PCoA}: See \code{\link{cmds}}. Classical Multidimensional Scaling (cMDS) takes a set of dissimilarities (i.e., a distance matrix) and returns a set of points such that the distances between the points are approximately equal to the dissimilarities.
}

\itemize{
\item \strong{DRR}: See \code{\link{DRR}}. Dimensionality Reduction via Regression (DRR) is a very recent technique extending PCA (Laparra et al., 2015). Starting from a rotated PCA, it predicts redundant information from the remaining components using non-linear regression. Some of the most notable advantages of performing PCR are avoidance of multicollinearity between predictors and overfitting mitigation. PCR tends to perform well when the first principal components are enough to explain most of the variation in the predictors. Requires the \pkg{DRR} package to be installed.
}

\itemize{
\item \strong{ICA}: See \code{\link{ICA}}. Performs an Independent Component Analysis using the FastICA algorithm. Contrary to PCA, that attempts to find uncorrelated sources (through least squares minimization), ICA attempts to find independent sources, i.e., the source space that maximizes the "non-gaussianity" of all sources. Contrary to PCA, ICA does not rank each source, which makes it a poor tool for dimensionality reduction. Requires the \pkg{fastICA} package to be installed.
}


}
}
\examples{
out <- parameters_reduction(iris, method = "PCA", n = "max")
head(out)
}
\references{
\itemize{
 \item Nguyen, L. H., \& Holmes, S. (2019). Ten quick tips for effective dimensionality reduction. PLOS Computational Biology, 15(6).
 \item Laparra, V., Malo, J., & Camps-Valls, G. (2015). Dimensionality reduction via regression in hyperspectral imagery. IEEE Journal of Selected Topics in Signal Processing, 9(6), 1026-1036.
}
}
