% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_parameters.R
\name{sort_parameters}
\alias{sort_parameters}
\alias{sort_parameters.default}
\title{Sort parameters by coefficient values}
\usage{
sort_parameters(x, ...)

\method{sort_parameters}{default}(x, sort = "none", column = "Coefficient", ...)
}
\arguments{
\item{x}{A data frame or a \code{parameters_model} object.}

\item{...}{Arguments passed to or from other methods.}

\item{sort}{If \code{"none"} (default) do not sort, \code{"ascending"} sort by
increasing coefficient value, or \code{"descending"} sort by decreasing
coefficient value.}

\item{column}{The column containing model parameter estimates. This will be
\code{"Coefficient"} (default) in \emph{easystats} packages, \code{"estimate"} in \emph{broom}
package, etc.}
}
\value{
A sorted data frame or original object.
}
\description{
Sort parameters by coefficient values
}
\examples{
# creating object to sort (can also be a regular data frame)
mod <- model_parameters(stats::lm(wt ~ am * cyl, data = mtcars))

# original output
mod

# sorted outputs
sort_parameters(mod, sort = "ascending")
sort_parameters(mod, sort = "descending")

}
