% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_table.R
\name{apa_table}
\alias{apa_table}
\alias{apa_table.apa_results_table}
\alias{apa_table.apa_results}
\alias{apa_table.matrix}
\alias{apa_table.list}
\alias{apa_table.data.frame}
\title{Prepare Table for Printing and Reporting}
\usage{
apa_table(x, ...)

\method{apa_table}{apa_results_table}(x, escape = FALSE, ...)

\method{apa_table}{apa_results}(x, ...)

\method{apa_table}{matrix}(
  x,
  caption = NULL,
  note = NULL,
  stub_indents = NULL,
  added_stub_head = NULL,
  col_spanners = NULL,
  midrules = NULL,
  placement = "tbp",
  landscape = FALSE,
  font_size = NULL,
  escape = TRUE,
  span_text_columns = TRUE,
  ...,
  format.args = NULL
)

\method{apa_table}{list}(
  x,
  caption = NULL,
  note = NULL,
  stub_indents = NULL,
  added_stub_head = NULL,
  col_spanners = NULL,
  midrules = NULL,
  placement = "tbp",
  landscape = FALSE,
  font_size = NULL,
  escape = TRUE,
  merge_method = "indent",
  span_text_columns = TRUE,
  ...,
  format.args = NULL
)

\method{apa_table}{data.frame}(
  x,
  caption = NULL,
  note = NULL,
  stub_indents = NULL,
  added_stub_head = NULL,
  col_spanners = NULL,
  midrules = NULL,
  placement = "tbp",
  landscape = FALSE,
  font_size = NULL,
  escape = TRUE,
  span_text_columns = TRUE,
  ...,
  format.args = NULL
)
}
\arguments{
\item{x}{Object to print, either a \code{matrix}, \code{data.frame}, or
\code{list}. See details.}

\item{...}{
  Arguments passed on to \code{\link[knitr:kable]{knitr::kable}}
  \describe{
    \item{\code{format}}{A character string. Possible values are \code{latex},
\code{html}, \code{pipe} (Pandoc's pipe tables), \code{simple} (Pandoc's
simple tables), and \code{rst}. The value of this argument will be
automatically determined if the function is called within a \pkg{knitr}
document. The \code{format} value can also be set in the global option
\code{knitr.table.format}. If \code{format} is a function, it must return a
character string.}
    \item{\code{digits}}{Maximum number of digits for numeric columns, passed to
\code{round()}. This can also be a vector of length \code{ncol(x)}, to set
the number of digits for individual columns.}
    \item{\code{row.names}}{Logical: whether to include row names. By default, row names
are included if \code{rownames(x)} is neither \code{NULL} nor identical to
\code{1:nrow(x)}.}
    \item{\code{col.names}}{A character vector of column names to be used in the table.}
    \item{\code{align}}{Column alignment: a character vector consisting of \code{'l'}
(left), \code{'c'} (center) and/or \code{'r'} (right). By default or if
\code{align = NULL}, numeric columns are right-aligned, and other columns
are left-aligned. If \code{length(align) == 1L}, the string will be
expanded to a vector of individual letters, e.g. \code{'clc'} becomes
\code{c('c', 'l', 'c')}, unless the output format is LaTeX.}
    \item{\code{label}}{The table reference label. By default, the label is obtained
from \code{knitr::\link[knitr]{opts_current}$get('label')}. To disable the label,
use \code{label = NA}.}
  }}

\item{escape}{Logical. If \code{TRUE} special LaTeX characters, such as
\code{\%} or \code{_}, in column names, row names, caption, note and table
contents are escaped.}

\item{caption}{Character. Caption to be printed above the table.}

\item{note}{Character. Note to be printed below the table.}

\item{stub_indents}{List. A named list of vectors that contain indices of
rows to indent. The name of each list element containing the vector is
used as title for indented sections.}

\item{added_stub_head}{Character. Used as stub head (name of first column)
if \code{row.names = TRUE} is passed to \code{\link[knitr]{kable}}; ignored if
row names are omitted from the table.}

\item{col_spanners}{List. A named list of vectors of length 2 that contain
the indices of the first and last column to span. The name of each list
element is used as grouping column name. Currently ignored in Word
documents.}

\item{midrules}{Numeric. Vector of line numbers in table (not counting
column headings) that should be followed by a horizontal rule; currently
ignored in Word documents.}

\item{placement}{Character. Indicates whether table should be placed, for
example, at the current location (\code{h}), at the top (\code{t}), bottom
(\code{b}), or on a separate page (\code{p}). Arguments can be combined to
indicate order of preference (\code{htb}); currently ignored when
\code{longtable = TRUE}, \code{landscape = TRUE}, and in Word documents.}

\item{landscape}{Logical. If \code{TRUE} the table is printed in landscape
mode; currently ignored in Word documents.}

\item{font_size}{Character. Font size to use for table contents (can be
\code{tiny}, \code{scriptsize}, \code{footnotesize}, \code{small},
\code{normalsize} (default), \code{large}, \code{Large}, \code{LARGE},
\code{huge}, \code{Huge}). Ignored in Word documents.}

\item{span_text_columns}{Logical. If \code{TRUE} tables span across text columns
in two-column PDF documents (e.g. when setting \code{classoption: jou}).
Otherwise ignored.}

\item{format.args}{List. A named list of arguments to be passed to
\code{\link{apa_num}} to format numeric values.}

\item{merge_method}{Character. Determines how to merge tables if \code{x} is
a \code{list} of matrices or data frames with a common structure. Can be either
\code{indent} or \code{table_spanner}. See details.}
}
\value{
A character vector of the table source code of class \code{knit_asis}, see
\code{\link[knitr:asis_output]{knitr::asis_output()}}.
}
\description{
Formats matrices and data frames to report them as tables in R Markdown
documents according to APA guidelines.
}
\details{
When using \code{apa_table}, the type of the output (LaTeX or Word) is
determined automatically by the rendered document type. In interactive R
session the output defaults to LaTeX.

If \code{x} is a \code{list}, all list elements are merged by columns into a single
table and the names of list elements are added according to the setting of
\code{merge_method}.

By default, the width of the table is set to accommodate its contents. In
some cases, this may cause the table to exceed the page width. To address
this, tables can be rotated 90 degrees by setting \code{langscape = TRUE} or,
by explicitly using "paragraph columns" with fixed column widths, such
that the contents is automatically broken into multiple lines. For
example, set \code{align = "lm{5cm}l"} to limit the second column to a width of
5 cm. Similarly, to space columns equally use
\code{align = paste0("m{", 1/(ncol(x) + 1), "\\\\linewidth}")}

Note that placement options are not supported in appendices of \code{apa6}
documents and will be printed to the document. To omit the printed options
set \code{placement = NULL}.
}
\examples{

my_table <- t(apply(cars, 2, function(x) # Create data
  round(c(Mean = mean(x), SD = sd(x), Min = min(x), Max = max(x)), 2)
))

apa_table(
  my_table
  , align = c("l", rep("r", 3))
  , caption = "A summary table of the cars dataset."
)

apa_table(
  cbind(my_table, my_table)
  , align = c("l", rep("r", 8))
  , caption = "A summary table of the cars dataset."
  , note = "This table was created using apa\\\\_table()"
  , added_stub_head = "Variables"
  , col_spanners = list(`Cars 1` = c(2, 5), `Cars 2` = c(6, 9))
)

apa_table(
  list(`Cars 1` = my_table, `Cars 2` = my_table)
  , caption = "A summary table of the cars dataset."
  , added_stub_head = "Variables"
)
}
\seealso{
\code{\link[knitr:kable]{knitr::kable()}}, \code{\link[=apa_num]{apa_num()}}
}
