% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{opt.joint.OU}
\alias{opt.joint.OU}
\title{Fit Ornstein-Uhlenbeck model using the "Joint" parameterization}
\usage{
opt.joint.OU(
  y,
  pool = TRUE,
  cl = list(fnscale = -1),
  meth = "L-BFGS-B",
  hess = FALSE
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{cl}{optional control list, passed to \code{optim()}}

\item{meth}{optimization algorithm, passed to \code{optim()}}

\item{hess}{if TRUE, return standard errors of parameter estimates from the
hessian matrix}
}
\value{
a \code{paleoTSfit} object with the model fitting results
}
\description{
Fit Ornstein-Uhlenbeck model using the "Joint" parameterization
}
\details{
This function fits an Ornstein-Uhlenbeck (OU) model to time-series data. The OU
model has four generating parameters: an ancestral trait value (\code{anc}), an optimum
value (\code{theta}), the strength of attraction to the optimum (\code{alpha}), and a
parameter that reflects the tendency of traits to diffuse (\code{vstep}).  In a
microevolutionary context, these parameters can be related to natural selection and
genetic drift; see Hunt et al. (2008).
}
\note{
It is easier to use the convenience function \code{fitSimple}.  Note also that
preliminary work found that the "AD" parameterization did not perform as well for the OU
model and thus it is not implemented here.
}
\examples{
x <- sim.OU(vs = 0.5)  # most defaults OK
w <- opt.joint.OU(x)
plot(x, modelFit = w)
}
\references{
Hunt, G., M. A. Bell and M. P. Travis. 2008. Evolution toward a new adaptive
optimum: phenotypic evolution in a fossil stickleback lineage. \emph{Evolution} 62(3):
700-710.
}
\seealso{
\code{\link{fitSimple}}, \code{\link{opt.joint.GRW}}
}
