% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{compareModels}
\alias{compareModels}
\title{Compare model fits for a paleontological time-series}
\usage{
compareModels(..., silent = FALSE, sort = FALSE)
}
\arguments{
\item{...}{any number of model fit (\code{as.paleoTSfit}) objects}

\item{silent}{if \code{TRUE}, suppresses printing}

\item{sort}{if \code{TRUE}, the table sorts models from best to worst}
}
\value{
if \code{silent = FALSE}, the table is printed and nothing is
  returned. If  \code{silent = TRUE}, printing is suppressed and a list of
  two objects is returned: the table of model fits, \code{modelFits}, and a
  list of parameter estimates, \code{pl}.
}
\description{
Takes output from model-fitting functions and compiles model-fit
  information (log-likelihood, AICc, etc.) into a convenient table
}
\examples{
x <- sim.GRW(ns = 40, ms = 0.5, vs = 0.1)
m1 <- fitSimple(x, model = "GRW")  # the true model
m2 <- fitSimple(x, model = "URW")
plot(x, modelFit = m1)
compareModels(m1, m2)
}
