% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{convert.sptab}
\alias{convert.sptab}
\title{Convert geological ages in taxon-range tables as constructed by mk.sptab() for plotting alongside a time-calibrated phylogeny.}
\usage{
convert.sptab(sptab, tree = NULL, root.time = tree$root.time)
}
\arguments{
\item{sptab}{Taxon-range table to convert}

\item{tree}{Optional phylogenetic tree to draw root.time from}

\item{root.time}{Root time of the tree, used for converting ages}
}
\value{
A data.frame() object in the format of the original taxon-range table, but with geological ages converted for plotting alongside the the phylogenetic tree.
}
\description{
Convert geological ages in taxon-range tables as constructed by mk.sptab() for plotting alongside a time-calibrated phylogeny.
}
\examples{
data(archosauria)
data(tree_archosauria)
convert.sptab(archosauria$Coelophysoidea,tree_archosauria)
}
