% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotplot.R
\name{dotplot}
\alias{dotplot}
\title{Generate a dot plot from a paf alignment}
\usage{
dotplot(
  ali,
  order_by = c("size", "qstart", "provided"),
  label_seqs = FALSE,
  dashes = TRUE,
  ordering = list(),
  alignment_colour = "black",
  xlab = "query",
  ylab = "target",
  line_size = 2
)
}
\arguments{
\item{ali}{pafr or tibble containing the genome alignment (as returned by
\code{\link{read_paf}})}

\item{order_by}{How the query and target sequences should be ordered in the
dot plot. Option must be one of 'size' (smallest-to-largest), 'qstart' (query organised
smallest to largest, target by first match in the query genome) or 'provided'
(ordering as specified in the \code{ordering} argument)}

\item{label_seqs}{boolean  If TRUE, label centre of query and target
sequences in margins of the dot plot}

\item{dashes}{boolean  If TRUE, add dashes to borders of query and
target sequences in the dot plot}

\item{ordering}{If \code{order_by} is set to TRUE,
this variable should be a list with two elements specifying the order of query
and then target sequences in the dot plot. This option is ignored if
\code{order_by} is set to other values}

\item{alignment_colour}{character  The colour used to draw each aligned
section in the dot plot (defaults to black)}

\item{xlab}{character  The x-axis label (defaults to 'query')}

\item{ylab}{character  The y-axis label (defaults to 'target')}

\item{line_size}{The width of the line used to represent an alignment in the
dot plot (defaults to 2)}
}
\description{
Generate a dot plot from a paf alignment
}
\examples{
ali <- read_paf( system.file("extdata", "fungi.paf", package="pafr") )
dotplot(ali)
dotplot(ali) + theme_bw()
dotplot(ali, label_seqs=TRUE, order_by="qstart", alignment_colour="blue")
}
