% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{pac_true_size}
\alias{pac_true_size}
\title{True size of the package}
\usage{
pac_true_size(
  pac,
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = NULL,
  exclude_joint = 0L
)
}
\arguments{
\item{pac}{character a package name.}

\item{fields}{character vector, Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{character vector, Default: NULL}

\item{exclude_joint}{integer exclude packages which are dependencies of at least N other packages, not count main package dependencies. Default: 0}
}
\value{
numeric size in bytes, to get MB then divide by \code{10**6}.
}
\description{
True size of the package as it takes into account its dependencies.
}
\note{
R base packages are not counted.
}
\examples{
# size in MB, with all its dependencies
pacs::pac_true_size("memoise") / 10**6

}
