% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{use_linear_mixed_model}
\alias{use_linear_mixed_model}
\title{Function for mixed effect regression}
\usage{
use_linear_mixed_model(
  param_to_be_estimated,
  dataset,
  fix_eff,
  fix_eff_interact_vars,
  random_intercept_vars,
  nested_intercept_vars_pairs,
  cross_intercept_vars_pairs,
  uncorrel_slope_intercept_pairs,
  random_slope_intercept_pairs
)
}
\arguments{
\item{param_to_be_estimated}{column name of dependent variable}

\item{dataset}{a dataframe}

\item{fix_eff}{names of variables as fixed effect predictors}

\item{fix_eff_interact_vars, }{those of the fixed effect predictors that
show interaction}

\item{random_intercept_vars, }{names of variables for random intercept}

\item{nested_intercept_vars_pairs, }{those of the random intercept variables
with nested effect}

\item{cross_intercept_vars_pairs, }{those of the random intercept variables
with crossed effect}

\item{uncorrel_slope_intercept_pairs, }{variables with no correlated
intercepts}

\item{random_slope_intercept_pairs, }{random slopes intercept pairs - this
is a list of paired variables}
}
\value{
result regression result with plot if success and -1, if failure
}
\description{
Function for mixed effect regression
}
\examples{
\donttest{
datafile <- system.file("extdata", "data_linear_mixed_model.csv",
package = "packDAMipd")
dataset = utils::read.table(datafile, header = TRUE, sep = ",",
na.strings = "NA",
dec = ".", strip.white = TRUE)
result <- use_linear_mixed_model("extro",
  dataset = dataset,
  fix_eff = c("open", "agree", "social"), fix_eff_interact_vars = NULL,
  random_intercept_vars = c("school", "class"),
  nested_intercept_vars_pairs = list(c("school", "class")),
  cross_intercept_vars_pairs = NULL, uncorrel_slope_intercept_pairs = NULL,
  random_slope_intercept_pairs = NULL)
}
}
