% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_thres_mean_ensembles.R
\name{max_ensemble}
\alias{max_ensemble}
\title{Computes an ensemble score using the maximum score of each observation}
\usage{
max_ensemble(X)
}
\arguments{
\item{X}{The input data containing the outlier scores in a dataframe, matrix or tibble format. Rows contain observations and columns contain outlier detection methods.}
}
\value{
The ensemble scores.
}
\description{
This function computes an ensemble score using the maximum score for each observation as detailed in Aggarwal and Sathe (2015) <doi:10.1145/2830544.2830549>.
}
\examples{
set.seed(123)
X <- data.frame(x1 = rnorm(200), x2 = rnorm(200))
X[199, ] <- c(4, 4)
X[200, ] <- c(-3, 5)
y1 <- DDoutlier::KNN_AGG(X)
y2 <- DDoutlier::LOF(X)
y3 <- DDoutlier::COF(X)
y4 <- DDoutlier::INFLO(X)
y5 <- DDoutlier::KDEOS(X)
y6 <- DDoutlier::LDF(X)
y7 <- DDoutlier::LDOF(X)
Y <- cbind.data.frame(y1, y2, y3, y4, y5, y6, y7)
ens <- max_ensemble(Y)
ens

}
