/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.Cell;
import fr.ird.osmose.School;
import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.util.SimulationLinker;
import fr.ird.osmose.util.io.IOTools;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class SpatialOutput
extends SimulationLinker
implements IOutput {
    private final float FILLVALUE = -99.0f;
    private NetcdfFileWriteable nc;
    private float[][][] biomass;
    private float[][][] mean_size;
    private float[][][] tl;
    private float[][][] ltlbiomass;
    private float[][][] abundance;
    private float[][][] yield;
    private boolean cutoff;

    public SpatialOutput(int rank) {
        super(rank);
    }

    private boolean includeClassZero() {
        return !this.cutoff;
    }

    @Override
    public void init() {
        this.cutoff = this.getConfiguration().getBoolean("output.cutoff.enabled");
        try {
            this.nc = NetcdfFileWriteable.createNew("");
            String filename = this.getFilename();
            IOTools.makeDirectories(filename);
            this.nc.setLocation(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        Dimension speciesDim = this.nc.addDimension("species", this.getNSpecies());
        Dimension ltlDim = this.nc.addDimension("ltl", this.getConfiguration().getNPlankton());
        Dimension columnsDim = this.nc.addDimension("nx", this.getGrid().get_nx());
        Dimension linesDim = this.nc.addDimension("ny", this.getGrid().get_ny());
        Dimension timeDim = this.nc.addUnlimitedDimension("time");
        this.nc.addVariable("time", DataType.FLOAT, new Dimension[]{timeDim});
        this.nc.addVariableAttribute("time", "units", "days since 0-1-1 0:0:0");
        this.nc.addVariableAttribute("time", "calendar", "360_day");
        this.nc.addVariableAttribute("time", "description", "time ellapsed, in days, since the beginning of the simulation");
        this.nc.addVariable("biomass", DataType.FLOAT, new Dimension[]{timeDim, speciesDim, linesDim, columnsDim});
        this.nc.addVariableAttribute("biomass", "units", "ton");
        this.nc.addVariableAttribute("biomass", "description", "biomass, in tons, per species and per cell");
        this.nc.addVariableAttribute("biomass", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("abundance", DataType.FLOAT, new Dimension[]{timeDim, speciesDim, linesDim, columnsDim});
        this.nc.addVariableAttribute("abundance", "units", "number of fish");
        this.nc.addVariableAttribute("abundance", "description", "Number of fish per species and per cell");
        this.nc.addVariableAttribute("abundance", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("yield", DataType.FLOAT, new Dimension[]{timeDim, speciesDim, linesDim, columnsDim});
        this.nc.addVariableAttribute("yield", "units", "ton");
        this.nc.addVariableAttribute("yield", "description", "Catches, in tons, per species and per cell");
        this.nc.addVariableAttribute("yield", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("mean_size", DataType.FLOAT, new Dimension[]{timeDim, speciesDim, linesDim, columnsDim});
        this.nc.addVariableAttribute("mean_size", "units", "centimeter");
        this.nc.addVariableAttribute("mean_size", "description", "mean size, in centimeter, per species and per cell");
        this.nc.addVariableAttribute("mean_size", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("trophic_level", DataType.FLOAT, new Dimension[]{timeDim, speciesDim, linesDim, columnsDim});
        this.nc.addVariableAttribute("trophic_level", "units", "scalar");
        this.nc.addVariableAttribute("trophic_level", "description", "trophic level per species and per cell");
        this.nc.addVariableAttribute("trophic_level", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("ltl_biomass", DataType.FLOAT, new Dimension[]{timeDim, ltlDim, linesDim, columnsDim});
        this.nc.addVariableAttribute("ltl_biomass", "units", "ton/km2");
        this.nc.addVariableAttribute("ltl_biomass", "description", "plankton biomass, in tons per km2 integrated on water column, per group and per cell");
        this.nc.addVariableAttribute("ltl_biomass", "_FillValue", Float.valueOf(-99.0f));
        this.nc.addVariable("latitude", DataType.FLOAT, new Dimension[]{linesDim, columnsDim});
        this.nc.addVariableAttribute("latitude", "units", "degree");
        this.nc.addVariableAttribute("latitude", "description", "latitude of the center of the cell");
        this.nc.addVariable("longitude", DataType.FLOAT, new Dimension[]{linesDim, columnsDim});
        this.nc.addVariableAttribute("longitude", "units", "degree");
        this.nc.addVariableAttribute("longitude", "description", "longitude of the center of the cell");
        this.nc.addGlobalAttribute("dimension_step", "step=0 before predation, step=1 after predation");
        StringBuilder str = new StringBuilder();
        for (int kltl = 0; kltl < this.getConfiguration().getNPlankton(); ++kltl) {
            str.append(kltl);
            str.append("=");
            str.append(this.getSimulation().getPlankton(kltl));
            str.append(" ");
        }
        this.nc.addGlobalAttribute("dimension_ltl", str.toString());
        str = new StringBuilder();
        for (int ispec = 0; ispec < this.getConfiguration().getNSpecies(); ++ispec) {
            str.append(ispec);
            str.append("=");
            str.append(this.getSpecies(ispec).getName());
            str.append(" ");
        }
        this.nc.addGlobalAttribute("dimension_species", str.toString());
        this.nc.addGlobalAttribute("include_age_class_zero", Boolean.toString(this.includeClassZero()));
        try {
            this.nc.create();
            ArrayFloat.D2 arrLon = new ArrayFloat.D2(this.getGrid().get_ny(), this.getGrid().get_nx());
            ArrayFloat.D2 arrLat = new ArrayFloat.D2(this.getGrid().get_ny(), this.getGrid().get_nx());
            for (Cell cell : this.getGrid().getCells()) {
                arrLon.set(cell.get_jgrid(), cell.get_igrid(), cell.getLon());
                arrLat.set(cell.get_jgrid(), cell.get_igrid(), cell.getLat());
            }
            this.nc.write("longitude", arrLon);
            this.nc.write("latitude", arrLat);
        }
        catch (IOException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void close() {
        try {
            this.nc.close();
            String strFilePart = this.nc.getLocation();
            String strFileBase = strFilePart.substring(0, strFilePart.indexOf(".part"));
            File filePart = new File(strFilePart);
            File fileBase = new File(strFileBase);
            filePart.renameTo(fileBase);
        }
        catch (IOException ex) {
            this.warning("Problem closing the NetCDF spatial output file | {0}", ex.toString());
        }
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        int nSpecies = this.getNSpecies();
        int nx = this.getGrid().get_nx();
        int ny = this.getGrid().get_ny();
        this.biomass = new float[nSpecies][ny][nx];
        this.mean_size = new float[nSpecies][ny][nx];
        this.tl = new float[nSpecies][ny][nx];
        this.ltlbiomass = new float[this.getConfiguration().getNPlankton()][ny][nx];
        this.abundance = new float[nSpecies][ny][nx];
        this.yield = new float[nSpecies][ny][nx];
    }

    @Override
    public void update() {
        for (Cell cell : this.getGrid().getCells()) {
            if (cell.isLand()) continue;
            int i = cell.get_igrid();
            int j = cell.get_jgrid();
            for (School school : this.getSchoolSet().getSchools(cell)) {
                if (!this.includeClassZero() && school.getAgeDt() < school.getSpecies().getAgeClassZero() || school.isUnlocated()) continue;
                int iSpec = school.getSpeciesIndex();
                float[] fArray = this.biomass[iSpec][j];
                int n = i;
                fArray[n] = (float)((double)fArray[n] + school.getInstantaneousBiomass());
                float[] fArray2 = this.abundance[iSpec][j];
                int n2 = i;
                fArray2[n2] = (float)((double)fArray2[n2] + school.getInstantaneousAbundance());
                float[] fArray3 = this.mean_size[iSpec][j];
                int n3 = i;
                fArray3[n3] = (float)((double)fArray3[n3] + (double)school.getLength() * school.getInstantaneousAbundance());
                float[] fArray4 = this.tl[iSpec][j];
                int n4 = i;
                fArray4[n4] = (float)((double)fArray4[n4] + (double)school.getTrophicLevel() * school.getInstantaneousBiomass());
                float[] fArray5 = this.yield[iSpec][j];
                int n5 = i;
                fArray5[n5] = (float)((double)fArray5[n5] + school.adb2biom(school.getNdead(MortalityCause.FISHING)));
            }
            for (int iltl = 0; iltl < this.getConfiguration().getNPlankton(); ++iltl) {
                this.ltlbiomass[iltl][j][i] = (float)this.getSimulation().getPlankton(iltl).getBiomass(cell);
            }
        }
    }

    @Override
    public void write(float time) {
        int i;
        int j;
        for (Cell cell : this.getGrid().getCells()) {
            int ispec;
            int i2 = cell.get_igrid();
            int j2 = cell.get_jgrid();
            if (cell.isLand()) {
                for (ispec = 0; ispec < this.getNSpecies(); ++ispec) {
                    this.biomass[ispec][j2][i2] = -99.0f;
                    this.abundance[ispec][j2][i2] = -99.0f;
                    this.mean_size[ispec][j2][i2] = -99.0f;
                    this.tl[ispec][j2][i2] = -99.0f;
                    this.yield[ispec][j2][i2] = -99.0f;
                }
                for (int iltl = 0; iltl < this.getConfiguration().getNPlankton(); ++iltl) {
                    this.ltlbiomass[iltl][j2][i2] = -99.0f;
                }
                continue;
            }
            for (ispec = 0; ispec < this.getNSpecies(); ++ispec) {
                if (!(this.abundance[ispec][j2][i2] > 0.0f)) continue;
                float[] fArray = this.mean_size[ispec][j2];
                int n = i2;
                fArray[n] = fArray[n] / this.abundance[ispec][j2][i2];
                float[] fArray2 = this.tl[ispec][j2];
                int n2 = i2;
                fArray2[n2] = fArray2[n2] / this.biomass[ispec][j2][i2];
            }
        }
        int nSpecies = this.getNSpecies();
        ArrayFloat.D4 arrBiomass = new ArrayFloat.D4(1, nSpecies, this.getGrid().get_ny(), this.getGrid().get_nx());
        ArrayFloat.D4 arrAbundance = new ArrayFloat.D4(1, nSpecies, this.getGrid().get_ny(), this.getGrid().get_nx());
        ArrayFloat.D4 arrYield = new ArrayFloat.D4(1, nSpecies, this.getGrid().get_ny(), this.getGrid().get_nx());
        ArrayFloat.D4 arrSize = new ArrayFloat.D4(1, nSpecies, this.getGrid().get_ny(), this.getGrid().get_nx());
        ArrayFloat.D4 arrTL = new ArrayFloat.D4(1, nSpecies, this.getGrid().get_ny(), this.getGrid().get_nx());
        ArrayFloat.D4 arrLTL = new ArrayFloat.D4(1, this.getConfiguration().getNPlankton(), this.getGrid().get_ny(), this.getGrid().get_nx());
        for (int kspec = 0; kspec < nSpecies; ++kspec) {
            for (j = 0; j < this.getGrid().get_ny(); ++j) {
                for (i = 0; i < this.getGrid().get_nx(); ++i) {
                    arrBiomass.set(0, kspec, j, i, this.biomass[kspec][j][i]);
                    arrAbundance.set(0, kspec, j, i, this.abundance[kspec][j][i]);
                    arrSize.set(0, kspec, j, i, this.mean_size[kspec][j][i]);
                    arrTL.set(0, kspec, j, i, this.tl[kspec][j][i]);
                    arrYield.set(0, kspec, j, i, this.yield[kspec][j][i]);
                }
            }
        }
        for (int kltl = 0; kltl < this.getConfiguration().getNPlankton(); ++kltl) {
            for (j = 0; j < this.getGrid().get_ny(); ++j) {
                for (i = 0; i < this.getGrid().get_nx(); ++i) {
                    arrLTL.set(0, kltl, j, i, this.ltlbiomass[kltl][j][i]);
                }
            }
        }
        ArrayFloat.D1 arrTime = new ArrayFloat.D1(1);
        arrTime.set(0, time * 360.0f);
        int index = this.nc.getUnlimitedDimension().getLength();
        try {
            this.nc.write("time", new int[]{index}, arrTime);
            this.nc.write("biomass", new int[]{index, 0, 0, 0}, arrBiomass);
            this.nc.write("abundance", new int[]{index, 0, 0, 0}, arrAbundance);
            this.nc.write("yield", new int[]{index, 0, 0, 0}, arrYield);
            this.nc.write("mean_size", new int[]{index, 0, 0, 0}, arrSize);
            this.nc.write("trophic_level", new int[]{index, 0, 0, 0}, arrTL);
            this.nc.write("ltl_biomass", new int[]{index, 0, 0, 0, 0}, arrLTL);
        }
        catch (IOException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(SpatialOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getFilename() {
        File path = new File(this.getConfiguration().getOutputPathname());
        StringBuilder filename = new StringBuilder(path.getAbsolutePath());
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_spatialized_Simu");
        filename.append(this.getRank());
        filename.append(".nc.part");
        return filename.toString();
    }

    @Override
    public boolean isTimeToWrite(int iStepSimu) {
        return true;
    }
}

