% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-auxiliar.R
\name{getMortalityDeviation}
\alias{getMortalityDeviation}
\title{Computes the mortality deviation. The "proxy", which is removed,
can be provided by the user in the "pars" argument.}
\usage{
getMortalityDeviation(x, stage, type, pars = NULL)
}
\arguments{
\item{x}{Mortality dataframe}

\item{stage}{Stage ("adults", etc.)}

\item{type}{Mortality type}

\item{pars}{A list or data frame containing
\emph{dt.save}, \emph{M.proxy}, \emph{dt} entries.
If NULL, then \code{proxy = colMeans(x)}}
}
\value{
An array
}
\description{
Computes the mortality deviation. The "proxy", which is removed,
can be provided by the user in the "pars" argument.
}
\examples{
{
dirin = system.file("extdata", package="osmose")
outdir = paste(dirin, "/outputs", sep="")
data = read_osmose(outdir)
mortality_df = data$global$mortality
mortdev = getMortalityDeviation(mortality_df, stage="juveniles", type="total")
}
}
