/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.version;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import fr.ird.osmose.util.Separator;
import fr.ird.osmose.util.version.AbstractVersion;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class Version3Update2
extends AbstractVersion {
    public Version3Update2() {
        super(3, 2, 2015, 2, 1);
    }

    @Override
    void updateParameters() {
        block12: {
            int iSpec;
            int nSpecies = this.getConfiguration().getInt("simulation.nspecies");
            for (iSpec = 0; iSpec < nSpecies; ++iSpec) {
                this.updateKey("population.initialization.biomass.sp" + iSpec, "population.seeding.biomass.sp" + iSpec);
            }
            this.deprecateParameter("population.initialization.method");
            if (!this.getConfiguration().isNull("population.initialization.method") && this.getConfiguration().getString("population.initialization.method").equalsIgnoreCase("biomass") && !this.getConfiguration().isNull("population.initialization.file")) {
                this.commentParameter("population.initialization.file", "Commented in order to avoid any interference with the new default seeding process");
            }
            this.deprecateParameter("population.initialization.spectrum.intercept");
            this.deprecateParameter("population.initialization.spectrum.range");
            this.deprecateParameter("population.initialization.spectrum.slope");
            this.deprecateParameter("flux.incoming.season.file");
            for (iSpec = 0; iSpec < nSpecies; ++iSpec) {
                this.deprecateParameter("flux.incoming.season.file.sp" + iSpec);
                this.deprecateParameter("flux.incoming.biomass.sp" + iSpec);
                this.deprecateParameter("flux.incoming.size.sp" + iSpec);
                this.deprecateParameter("flux.incoming.age.sp" + iSpec);
                if (this.getConfiguration().isNull("flux.incoming.biomass.sp" + iSpec)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (!(this.getConfiguration().getFloat(stringBuilder.append("flux.incoming.biomass.sp").append(iSpec).toString()) > 0.0f)) continue;
                this.addParameter("flux.incoming.byDt.byAge.file.sp" + iSpec, "null");
                this.addParameter("flux.incoming.byDt.bySize.file.sp" + iSpec, "null");
                StringBuilder msg = new StringBuilder();
                msg.append("Parameters for configuring the flux of ");
                msg.append(this.getConfiguration().getString("species.name.sp" + iSpec));
                msg.append(" biomass have changed. ");
                msg.append("You must provide time series of incoming biomass by time step, structured in age or size class, in a CSV file.\n");
                msg.append("Osmose cannot generate automatically this CSV file from the deprecated 'flux.incoming.*' parameters. Please create it manually and update the pathname of parameters flux.incoming.byDt.byAge/bySize.file.sp");
                msg.append(iSpec);
                msg.append("\nMore information is available on the Osmose website http://www.osmose-model.org/documentation/changes-osmose-3-update-2");
                this.warning(msg.toString());
            }
            this.deprecateParameter("reproduction.season.file");
            if (!this.getConfiguration().canFind("reproduction.season.file")) break block12;
            if (this.getConfiguration().isNull("reproduction.season.file")) {
                for (iSpec = 0; iSpec < nSpecies; ++iSpec) {
                    this.addParameter("reproduction.season.file.sp" + iSpec, "null");
                }
            } else {
                String absFilename = this.getConfiguration().getFile("reproduction.season.file");
                String absNewname = absFilename.substring(0, absFilename.lastIndexOf(".")) + "-sp";
                String relFilename = this.getConfiguration().getString("reproduction.season.file");
                String relNewname = relFilename.substring(0, relFilename.lastIndexOf(".")) + "-sp";
                try {
                    CSVReader reader = new CSVReader(new FileReader(absFilename), Separator.guess(absFilename).getSeparator());
                    List<String[]> lines = reader.readAll();
                    reader.close();
                    for (int iSpec2 = 0; iSpec2 < nSpecies; ++iSpec2) {
                        String csvfile = absNewname + String.valueOf(iSpec2) + ".csv";
                        try {
                            CSVWriter writer = new CSVWriter(new FileWriter(csvfile), ';');
                            for (String[] line : lines) {
                                String[] newline = new String[]{line[0], line[iSpec2 + 1]};
                                writer.writeNext(newline);
                            }
                            writer.close();
                            this.info("  Created reproduction seasonality file for species " + iSpec2 + " " + csvfile);
                        }
                        catch (IOException ex) {
                            this.error("Error writing CSV file " + csvfile, ex);
                        }
                        String filename = relNewname + String.valueOf(iSpec2) + ".csv";
                        this.addParameter("reproduction.season.file.sp" + iSpec2, filename);
                    }
                }
                catch (IOException ex) {
                    this.error("Error reading CSV file " + absFilename, ex);
                }
            }
        }
    }
}

