/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.step;

import fr.ird.osmose.School;
import fr.ird.osmose.output.OutputManager;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.process.GrowthProcess;
import fr.ird.osmose.process.IncomingFluxProcess;
import fr.ird.osmose.process.ReproductionProcess;
import fr.ird.osmose.process.mortality.MortalityProcess;
import fr.ird.osmose.process.movement.MovementProcess;
import fr.ird.osmose.step.AbstractStep;

public class DefaultStep
extends AbstractStep {
    private AbstractProcess growthProcess;
    private AbstractProcess reproductionProcess;
    private AbstractProcess incomingFLuxProcess;
    private AbstractProcess mortalityProcess;
    private AbstractProcess movementProcess;
    private OutputManager indicators;
    private boolean recordStep0;

    public DefaultStep(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        this.mortalityProcess = new MortalityProcess(this.getRank());
        this.mortalityProcess.init();
        this.growthProcess = new GrowthProcess(this.getRank());
        this.growthProcess.init();
        this.reproductionProcess = new ReproductionProcess(this.getRank());
        this.reproductionProcess.init();
        this.incomingFLuxProcess = new IncomingFluxProcess(this.getRank());
        this.incomingFLuxProcess.init();
        this.movementProcess = new MovementProcess(this.getRank());
        this.movementProcess.init();
        this.indicators = new OutputManager(this.getRank());
        this.indicators.init();
        this.recordStep0 = this.getConfiguration().getBoolean("output.step0.include");
    }

    @Override
    public void step(int iStepSimu) {
        this.incomingFLuxProcess.run();
        for (School school : this.getSchoolSet()) {
            school.init();
        }
        this.getForcing().update(iStepSimu);
        this.indicators.initStep();
        this.movementProcess.run();
        if (this.recordStep0 && iStepSimu == 0) {
            this.indicators.update(-1);
        }
        this.mortalityProcess.run();
        this.growthProcess.run();
        this.indicators.update(iStepSimu);
        this.reproductionProcess.run();
        this.getSchoolSet().removeDeadSchools();
    }

    @Override
    public void end() {
        this.indicators.close();
    }
}

