/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality.fishing;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.fishing.AbstractFishingMortality;
import fr.ird.osmose.util.timeseries.ByClassTimeSeries;

public class RateByDtByClassFishingMortality
extends AbstractFishingMortality {
    private double[][] f;
    private float[] sizeThreshold;
    private int[] ageThreshold;

    public RateByDtByClassFishingMortality(int rank, Species species) {
        super(rank, species);
    }

    @Override
    public void init() {
        int iSpec = this.getIndexSpecies();
        if (!this.getConfiguration().isNull("mortality.fishing.rate.byDt.byAge.file.sp" + iSpec)) {
            ByClassTimeSeries timeSerieByAge = new ByClassTimeSeries(this.getRank());
            timeSerieByAge.read(this.getConfiguration().getFile("mortality.fishing.rate.byDt.byAge.file.sp" + iSpec));
            this.f = timeSerieByAge.getValues();
            this.ageThreshold = new int[timeSerieByAge.getNClass() - 1];
            for (int k = 0; k < this.ageThreshold.length; ++k) {
                this.ageThreshold[k] = Math.round(timeSerieByAge.getClass(k) * (float)this.getConfiguration().getNStepYear());
            }
        } else if (!this.getConfiguration().isNull("mortality.fishing.rate.byDt.bySize.file.sp" + iSpec)) {
            ByClassTimeSeries timeSerieBySize = new ByClassTimeSeries(this.getRank());
            timeSerieBySize.read(this.getConfiguration().getFile("mortality.fishing.rate.byDt.bySize.file.sp" + iSpec));
            this.f = timeSerieBySize.getValues();
            this.sizeThreshold = timeSerieBySize.getClasses();
        } else {
            this.getSimulation().error("Could not found parameters mortality.fishing.rate.byDt.byAge/bySize.file.sp" + iSpec, null);
        }
    }

    @Override
    public double getRate(School school) {
        if (null != this.sizeThreshold) {
            float length = school.getLength();
            if (length < this.sizeThreshold[0]) {
                return 0.0;
            }
            for (int k = 0; k < this.sizeThreshold.length - 1; ++k) {
                if (!(this.sizeThreshold[k] <= length) || !(length < this.sizeThreshold[k + 1])) continue;
                return this.f[this.getSimulation().getIndexTimeSimu()][k];
            }
            return this.f[this.getSimulation().getIndexTimeSimu()][this.sizeThreshold.length - 1];
        }
        if (null != this.ageThreshold) {
            float age = school.getAgeDt();
            if (age < (float)this.ageThreshold[0]) {
                return 0.0;
            }
            for (int k = 0; k < this.ageThreshold.length - 1; ++k) {
                if (!((float)this.ageThreshold[k] <= age) || !(age < (float)this.ageThreshold[k + 1])) continue;
                return this.f[this.getSimulation().getIndexTimeSimu()][k];
            }
            return this.f[this.getSimulation().getIndexTimeSimu()][this.ageThreshold.length - 1];
        }
        return Double.NaN;
    }

    @Override
    public double getCatches(School school) {
        throw new UnsupportedOperationException("No catches specified in this fishing scenario.");
    }

    @Override
    public void assessFishableBiomass() {
    }
}

