/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import fr.ird.osmose.stage.DietOutputStage;
import fr.ird.osmose.stage.IStage;
import java.io.File;

public class BiomassDietStageOutput
extends AbstractOutput {
    private int nColumns;
    private double[][] biomassStage;
    private IStage dietOutputStage;

    public BiomassDietStageOutput(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        this.dietOutputStage = new DietOutputStage();
        this.dietOutputStage.init();
        this.nColumns = 0;
        for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
            this.nColumns += this.dietOutputStage.getNStage(iSpec);
        }
        this.nColumns += this.getConfiguration().getNPlankton();
        super.init();
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getOutputPathname());
        filename.append(File.separatorChar);
        filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_biomassPredPreyIni_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "\\ Biomass (tons) of preys at the beginning of the time step (before all sources of mortality - fishing, predation, starvation, others)";
    }

    @Override
    String[] getHeaders() {
        int nSpec = this.getNSpecies();
        String[] headers = new String[this.nColumns];
        int k = 0;
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            String name = this.getSimulation().getSpecies(iSpec).getName();
            float[] threshold = this.dietOutputStage.getThresholds(iSpec);
            int nStage = this.dietOutputStage.getNStage(iSpec);
            for (int s = 0; s < nStage; ++s) {
                headers[k] = nStage == 1 ? name : (s == 0 ? name + " < " + threshold[s] : name + " >=" + threshold[s - 1]);
                ++k;
            }
        }
        for (int j = nSpec; j < nSpec + this.getConfiguration().getNPlankton(); ++j) {
            headers[k] = this.getSimulation().getPlankton(j - nSpec).getName();
            ++k;
        }
        return headers;
    }

    @Override
    public void initStep() {
        for (School school : this.getSchoolSet().getPresentSchools()) {
            double[] dArray = this.biomassStage[school.getSpeciesIndex()];
            int n = this.dietOutputStage.getStage(school);
            dArray[n] = dArray[n] + school.getBiomass();
        }
        int nSpec = this.getNSpecies();
        int nPrey = nSpec + this.getConfiguration().getNPlankton();
        for (int i = nSpec; i < nPrey; ++i) {
            int iPlankton = i - nSpec;
            double[] dArray = this.biomassStage[i];
            dArray[0] = dArray[0] + this.getSimulation().getPlankton(iPlankton).getTotalBiomass();
        }
    }

    @Override
    public void reset() {
        int nSpec = this.getNSpecies();
        int nPrey = nSpec + this.getConfiguration().getNPlankton();
        this.biomassStage = new double[nPrey][];
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            this.biomassStage[iSpec] = new double[this.dietOutputStage.getNStage(iSpec)];
        }
        for (int i = nSpec; i < nPrey; ++i) {
            this.biomassStage[i] = new double[1];
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void write(float time) {
        double[] biomass = new double[this.nColumns];
        double nsteps = this.getRecordFrequency();
        int k = 0;
        int nSpec = this.getNSpecies();
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            for (int s = 0; s < this.dietOutputStage.getNStage(iSpec); ++s) {
                biomass[k] = this.biomassStage[iSpec][s] / nsteps;
                ++k;
            }
        }
        for (int j = nSpec; j < nSpec + this.getConfiguration().getNPlankton(); ++j) {
            biomass[k] = this.biomassStage[j][0] / nsteps;
            ++k;
        }
        this.writeVariable(time, biomass);
    }
}

