## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 6,
  fig.height = 4
)
library('orloca')

## -----------------------------------------------------------------------------
loca.p(c(0, 4, 2), c(0, 0, 2))

## ----results = 'hide'---------------------------------------------------------
loca.p(x = c(0, 4, 2), y = c(0, 0, 2))

## ----include=TRUE-------------------------------------------------------------
loca.p(x = c(0, 4, 2), y = c(0, 0, 2), w = c(1, 1, 3), label = "Problema 1")

## ----include = FALSE----------------------------------------------------------
d <- data.frame(x = c(0, 10, 2), y = c(0, 0, 8), w = c(1, 3, 1))

## -----------------------------------------------------------------------------
d

## -----------------------------------------------------------------------------
as(d, "loca.p")

## ----results='hide'-----------------------------------------------------------
as.loca.p(d)

## -----------------------------------------------------------------------------
p1 <- loca.p(x = c(0, 4, 2), y = c(0, 0, 2), w = c(1, 1, 3), label = "Problema 1")
as(p1, 'data.frame')

## ----results='hide'-----------------------------------------------------------
as.data.frame(p1)

## -----------------------------------------------------------------------------
p1@label
dp1 <- as.data.frame(p1)
attr(dp1, "label")

## -----------------------------------------------------------------------------
set.seed(161236)
rloca.p(5)

## -----------------------------------------------------------------------------
rloca.p(5, xmin = -1, xmax = 1, ymin = -5, ymax = 5, label = "Rectángulo")

## -----------------------------------------------------------------------------
rloca.p(9, groups = 3, label = "Tres grupos iguales")

## -----------------------------------------------------------------------------
rloca.p(groups = c(2, 2, 5), label = "Tres grupos desiguales")

## -----------------------------------------------------------------------------
rl <- rloca.p(60, groups = 3, xmin = -10, xmax = 10, ymin = -10, ymax = 10, xgmin = -1, xgmax = 1, ygmin = -1, ygmax = 1, label = "Tres grupos")
plot(rl)

## -----------------------------------------------------------------------------
summary(rl)

## -----------------------------------------------------------------------------
pt3 <- loca.p(x = c(0, 4, 2), y = c(0, 0, 2), label = "Tres puntos")
distsum(o = pt3, x = 3, y = 1)

## -----------------------------------------------------------------------------
distsumgra(o = pt3, x = 3, y = 1)

## -----------------------------------------------------------------------------
s <- distsummin(pt3)
s

## -----------------------------------------------------------------------------
distsum(o = pt3, x = s[1], y = s[2])
distsumgra(o = pt3, x = s[1], y = s[2])

## -----------------------------------------------------------------------------
plot(pt3)

## -----------------------------------------------------------------------------
contour(pt3)

## -----------------------------------------------------------------------------
contour(pt3, xlim = c(1.9, 2.1), ylim = c(1, 1.2), levels = c(5.465, 5.47, 5.475))

## -----------------------------------------------------------------------------
persp(pt3)
persp(pt3, col = "lightblue", theta = 45, ltheta = 120, shade = 0.75, ticktype = "detailed")

## -----------------------------------------------------------------------------
data(andalusia)
o <- loca.p(x=andalusia$x[1:8], y=andalusia$y[1:8])

## -----------------------------------------------------------------------------
xmin <- min(andalusia$x)
ymin <- min(andalusia$y)
xmax <- max(andalusia$x)
ymax <- max(andalusia$y)

## -----------------------------------------------------------------------------
file = system.file('img', 'andalusian_provinces.png', package='orloca')
img = readPNG(file)
plot(o, img=img, main='Andalucía', xleft=xmin, ybottom=ymin, xright=xmax, ytop=ymax)

## -----------------------------------------------------------------------------
contour(o, img=img, main='Andalucía', xleft=xmin, ybottom=ymin, xright=xmax, ytop=ymax)

## -----------------------------------------------------------------------------
andalusia.loca.p <- loca.p(andalusia$x[1:8], andalusia$y[1:8])
sol <- distsummin(andalusia.loca.p)
sol

## -----------------------------------------------------------------------------
contour(o, img=img, main='Andalucía', xleft=xmin, ybottom=ymin, xright=xmax, ytop=ymax)
points(sol[1], sol[2], type='p', col='red')

