% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_get.R
\name{opt}
\alias{opt}
\alias{opt_source}
\alias{opts}
\title{Inspecting Option Values}
\usage{
opt(x, default, env = parent.frame())

opt_source(x, env = parent.frame())

opts(xs = NULL, env = parent.frame())
}
\arguments{
\item{x, xs}{An option name or vector of option names}

\item{default}{A default value if the option is not set}

\item{env}{An environment, namespace or package name to pull options from}
}
\value{
For \code{opt()} and \code{opts()}; the result of the option (or a list of
results), either the value from a global option, the result of processing
the environment variable or the default value, depending on which of the
alternative sources are defined.

For \code{opt_source()}; the source that is used for a specific option,
one of \code{"option"}, \code{"envir"} or \code{"default"}.
}
\description{
Inspecting Option Values
}
\section{Functions}{
\itemize{
\item \code{opt()}: Retrieve an option

\item \code{opt_source()}: Determine source of option value. Primarily used for diagnosing options
behaviors.

\item \code{opts()}: Retrieve multiple options. When no names are provided, return a list
containing all options from a given environment.

}}
\examples{
define_options("Whether execution should emit console output", quiet = FALSE)
opt("quiet")

define_options("Whether execution should emit console output", quiet = FALSE)
opt_source("quiet")

Sys.setenv(R_GLOBALENV_QUIET = TRUE)
opt_source("quiet")

options(globalenv.quiet = FALSE)
opt_source("quiet")

}
