\name{optimbase.new}
\alias{optimbase.new}
\title{
  Initialize optimbase Object
}
\description{
  This function creates a new object. 
}
\usage{
  optimbase.new()
}
\value{
  Return a new optimization object, i.e. a list with a 'type' attribute set to
  'T_OPTIMIZATION' and containing the following elements:\describe{
    \item{verbose}{The verbose option, controlling the amount of messages.
      Set to 0.}
    \item{x0}{The initial guess. Set to NULL.}
    \item{fx0}{The value of the function for the initial guess. Set to
      NULL.}
    \item{xopt}{The optimum parameter. Set to 0.}
    \item{fopt}{The optimum function value. Set to 0.}
    \item{tolfunabsolute}{The absolute tolerance on function value. Default
      is 0.}
    \item{tolfunrelative}{The relative tolerance on function value. Default
      is .Machine$double.eps.}
    \item{tolfunmethod}{Logical flag for the tolerance on function value in
      the termination criteria. This criteria is suitable for functions which
      minimum is associated with a function value equal to 0. Set to FALSE.}
    \item{tolxabsolute}{The absolute tolerance on x. Set to 0.}
    \item{tolxrelative}{The relative tolerance on x. Set to
      .Machine$double.eps.}
    \item{tolxmethod}{Possible values: FALSE, TRUE. Set to TRUE.}
    \item{funevals}{The number of function evaluations. Set to 0.}
    \item{maxfunevals}{The maximum number of function evaluations. Set to
      100.}
    \item{maxiter}{The maximum number of iterations. Set to 100.}
    \item{iterations}{The number of iterations. Set to 0.}
    \item{fun}{The cost function. Set to ''.}
    \item{status}{The status of the optimization. Set to ''.}
    \item{historyfopt}{The vector to store the history for fopt. The values of
      the cost function will be stored at each iteration in a new element, so
      the length of \code{historyfopt} at the end of the optimization should be
      the number of iterations. Set to NULL.}
    \item{historyxopt}{The list to store the history for xopt. The vectors of
      estimates will be stored on separated levels of the list, so the length of
      \code{historyfopt} at the end of the optimization should be the number of
      iterations. Set to NULL.}
    \item{verbosetermination}{The verbose option for termination criteria.
      Set to 0.}
    \item{outputcommand}{The command called back for output. Set to ''.}
    \item{outputcommandarg}{The outputcommand argument is initialized as a
      string. If the user configure this element, it is expected that a matrix
      of values or a list is passed so that the argument is appended to the name
      of the function. Set to ''.}
    \item{numberofvariables}{The number of variables to optimize. Set to
      0.}
    \item{storehistory}{The flag which enables/disables the storing of the
      history. Set to FALSE.}
    \item{costfargument}{The costf argument is initialized as a string. If
      the user configure this element, it is expected that a matrix of values
      or a list is passed so that the argument is appended to the name of the
      function. Set to ''.}
    \item{boundsmin}{Minimum bounds for the parameters. Set to NULL.}
    \item{boundsmax}{Maximum bounds for the parameters. Set to NULL.}
    \item{nbineqconst}{The number of nonlinear inequality constraints. Default
      is 0.}
    \item{logfile}{The name of the log file. Set to ''.}
    \item{logfilehandle}{The handle for the log file. Set to 0.}
    \item{logstartup}{Set to TRUE when the logging is started up. Set to
      FALSE.}
    \item{withderivatives}{Set to TRUE when the method uses derivatives.
      Set to FALSE.}
    }
}
\author{
  Author of Scilab optimbase module: Michael Baudin (INRIA - Digiteo)

  Author of R adaptation: Sebastien Bihorel (\email{sb.pmlab@gmail.com})
}
\keyword{ method }