% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{get_laugment_region}
\alias{get_laugment_region}
\title{Get L-augment region}
\usage{
get_laugment_region(
  init_design,
  alpha,
  model,
  parameters,
  par_values,
  design_space,
  calc_optimal_design,
  matB,
  weight_fun = function(x) 1
)
}
\arguments{
\item{init_design}{dataframe with "Point" and "Weight" columns that represents the initial design to augment}

\item{alpha}{combined weight of the new points}

\item{model}{formula that represent the model with x as the independent variable}

\item{parameters}{character vector with the unknown parameters of the model to estimate}

\item{par_values}{numeric vector with the initial values of the unknown parameters}

\item{design_space}{numeric vector with the limits of the space of the design}

\item{calc_optimal_design}{boolean parameter, if TRUE, the optimal design is calculated and efficiencies of the initial and augmented design are given}

\item{matB}{optional matrix of dimensions k x k, integral of the information matrix of the model over the
interest region for I-optimality.}

\item{weight_fun}{optional one variable function that represents the square of the structure of variance, in case of heteroscedastic variance of the response}
}
\value{
A vector of the points limiting the candidate points region
}
\description{
Given a model, calculates the candidate points region for L-Optimality. The user gives an initial
design for which he would like to add points and specifies the weight of the new points. Then he
is prompted to choose a minimum efficiency. After that, the candidate points region is calculated.
}
\examples{
init_des <- data.frame("Point" = c(30, 60, 90), "Weight" = c(1/3, 1/3, 1/3))
get_augment_region("D-Optimality", init_des, 0.25, y ~ 10^(a-b/(c+x)), c("a","b","c"),
  c(8.07131,  1730.63, 233.426), c(1, 100), TRUE)
get_augment_region("D-Optimality", init_des, 0.25, y ~ 10^(a-b/(c+x)), c("a","b","c"),
  c(8.07131,  1730.63, 233.426), c(1, 100), FALSE)
}
\seealso{
Other augment region: 
\code{\link{get_dsaugment_region}()}
}
\concept{augment region}
