% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Retrieve data from the Open-Meteo geocoding API}
\usage{
geocode(location_name, n_results = 1, language = "en", silent = TRUE)
}
\arguments{
\item{location_name}{Required. The location name to search for via fuzzy
matching.}

\item{n_results}{The number of matching locations provided in response,
sorted by relevance (default 1, up to 100).}

\item{language}{Desired response language for place names (lower-cased
two-letter string, i.e. "en" for \emph{London},"fr" for \emph{Londres}).}

\item{silent}{If \code{FALSE}, the top match will be printed to the console, to
aid in confirming the match is correct when used within other functions.}
}
\value{
Details for each matching location (latitude, longitude, elevation,
population, timezone, and administrative areas)
}
\description{
Call the Open-Meteo Geocoding API to retrieve co-ordinates and other
information for a given place name. The closest n matching records can be
requested.

Geocoding API documentation is available at
\url{https://open-meteo.com/en/docs/geocoding-api}.
}
\examples{
\donttest{
# obtain co-ordinates of Sydney
gc <- geocode("Sydney")
sydney_coords <- c(gc$latitude, gc$longitude)
sydney_coords

# elevation of Kathmandu
geocode("kathmandu")$elevation

# 10 places named 'Paris'
geocode("paris", 10)
}
}
