% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{topics2df}
\alias{topics2df}
\title{Convert OpenAlex collection of topics' records from list format to data frame}
\usage{
topics2df(
  data,
  verbose = TRUE,
  pb = if (verbose) oa_progress(length(data)) else NULL
)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{verbose}{Logical.
If TRUE, print information about the dataframe conversion process.
Defaults to TRUE.}

\item{pb}{Progress bar object. If verbose, computed from `oa_progress`.
NULL otherwise.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: <https://docs.openalex.org>
}
\description{
It converts collection of topics' records gathered from the OpenAlex database.
The function converts a list of topics' records obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Query to search information about all Italian educational institutions


query_inst <- oa_query(
  entity = "topics",
  display_name.search = "electrodynamics"
)

res <- oa_request(
  query_url = query_inst,
  count_only = FALSE,
  verbose = FALSE
)

df <- oa2df(res, entity = "topics")

df
}

}
