/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.List;
import java.util.regex.Pattern;
import opennlp.tools.namefind.FeatureGeneratorAdapter;
import opennlp.tools.namefind.FeatureGeneratorUtil;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.tokenize.Tokenizer;

public class TokenPatternFeatureGenerator
extends FeatureGeneratorAdapter {
    private Pattern noLetters = Pattern.compile("[^a-zA-Z]");
    private Tokenizer tokenizer;

    public TokenPatternFeatureGenerator() {
        this(new SimpleTokenizer());
    }

    public TokenPatternFeatureGenerator(Tokenizer supportTokenizer) {
        this.tokenizer = supportTokenizer;
    }

    public void createFeatures(List feats, String[] toks, int index, String[] preds) {
        String[] tokenized = this.tokenizer.tokenize(toks[index]);
        if (tokenized.length == 1) {
            feats.add("st=" + toks[index].toLowerCase());
            return;
        }
        feats.add("stn=" + tokenized.length);
        StringBuffer pattern = new StringBuffer();
        for (int i = 0; i < tokenized.length; ++i) {
            if (i < tokenized.length - 1) {
                feats.add("pt2=" + FeatureGeneratorUtil.tokenFeature(tokenized[i]) + FeatureGeneratorUtil.tokenFeature(tokenized[i + 1]));
            }
            if (i < tokenized.length - 2) {
                feats.add("pt3=" + FeatureGeneratorUtil.tokenFeature(tokenized[i]) + FeatureGeneratorUtil.tokenFeature(tokenized[i + 1]) + FeatureGeneratorUtil.tokenFeature(tokenized[i + 2]));
            }
            pattern.append(FeatureGeneratorUtil.tokenFeature(tokenized[i]));
            if (this.noLetters.matcher(tokenized[i]).find()) continue;
            feats.add("st=" + tokenized[i].toLowerCase());
        }
        feats.add("pta=" + pattern.toString());
    }
}

