/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.util.Iterator;
import opennlp.tools.ngram.Dictionary;
import opennlp.tools.ngram.NGram;

class DictionaryIterator
implements Iterator {
    Iterator wordIterator;
    Iterator gramIterator;
    boolean onWords;
    String[] words;
    Dictionary dict;

    public DictionaryIterator(Dictionary dict) {
        this.wordIterator = dict.wordMap.iterator();
        this.gramIterator = dict.gramSet.iterator();
        this.onWords = true;
        this.dict = dict;
    }

    public boolean hasNext() {
        if (this.onWords) {
            if (this.wordIterator.hasNext()) {
                return true;
            }
            this.onWords = false;
        }
        return this.gramIterator.hasNext();
    }

    public Object next() {
        if (this.onWords) {
            String word = (String)this.wordIterator.next();
            return word + "=" + this.dict.wordMap.getIndex(word);
        }
        int[] gramInts = ((NGram)this.gramIterator.next()).getWords();
        StringBuffer sb = new StringBuffer();
        for (int gi = 0; gi < gramInts.length; ++gi) {
            sb.append(gramInts[gi]).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void remove() {
        throw new UnsupportedOperationException("DictionaryIterator does not allow removal");
    }
}

