% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_mapping.R
\name{set_mapping}
\alias{set_mapping}
\title{Add a new mapping to an ontology}
\usage{
set_mapping(
  concept,
  external = NULL,
  match = "close",
  source = NULL,
  mappings = NULL,
  certainty = NULL,
  path = NULL
)
}
\arguments{
\item{concept}{\code{\link[=character]{character(.)}}\cr the english label(s) of already
harmonised concepts to which the external concepts shall be mapped.}

\item{external}{\code{\link[=character]{character(.)}}\cr the english label(s) of new
external concepts that shall be mapped to concepts that do already exist in
the ontology.}

\item{match}{\code{\link[=character]{character(1)}}\cr the
\href{https://www.w3.org/TR/skos-reference/#mapping}{skos mapping property}
used to describe the link, possible values are \code{"close"},
\code{"exact"}, \code{"broad"}, \code{"narrow"} and \code{"related"}.}

\item{source}{\code{\link[=character]{character(1)}}\cr any character uniquely
identifying the source dataset of the new concept.}

\item{mappings}{\code{\link[=tibble]{tibble()}}\cr not yet implemented.}

\item{certainty}{\code{\link[=integer]{integerish(1)}}\cr the certainty of the match.
Possible values are between 1 and 4, with meaning \itemize{\item 1 =
probably unreliable \item 2 = unclear, assigned according to a given
definition \item 3 = clear, assigned according to a given definition \item
4 = original, harmonised term (can't be assigned by a user)}.}

\item{path}{\code{\link[=character]{character(1)}}\cr the path where the ontology in
which to search is stored. It can be omitted in case the option "onto_path"
has been define (see \code{getOption("onto_path")}).}
}
\value{
No return value, called for the side effect of adding new mappings to
an ontology.
}
\description{
Extend an ontology by creating mappings to external vocabularies.
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")

set_mapping(concept = c("BIOENERGY CROPS", "Bioenergy woody", "Other bioenergy crops"),
            external = c("bioenergy plants", "Wood plantation for fuel", "Algae for bioenergy"),
            match = c("close", "broad", "broad"),
            source = "external_dataset",
            certainty = 3,
            path = ontoDir)

load_ontology(path = ontoDir)
}
