% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_concept.R
\name{new_concept}
\alias{new_concept}
\title{Add a new concept to an ontology}
\usage{
new_concept(
  new,
  broader,
  class = NULL,
  source,
  overwrite = FALSE,
  attributes = NULL,
  path = NULL
)
}
\arguments{
\item{new}{\code{\link[=character]{character(.)}}\cr the english label(s) of new
concepts that shall be included in the ontology.}

\item{broader}{\code{\link[=character]{character(.)}}\cr the english label(s) of already
harmonised concepts to which the new concept shall be semantically linked
via a
\href{https://www.w3.org/TR/skos-reference/#semantic-relations}{skos:broader}
relation, see Details.}

\item{class}{\code{\link[=character]{character(.)}}\cr the class(es) of the new labels.}

\item{source}{\code{\link[=character]{character(1)}}\cr any character uniquely
identifying the source dataset of the new concept (for example
\emph{Author+Year}).}

\item{overwrite}{\code{\link[=logical]{logical(1)}} whether or not to overwrite already
existing concepts.}

\item{attributes}{\code{\link[=tibble]{tibble()}}\cr not yet implemented.}

\item{path}{\code{\link[=character]{character(1)}}\cr the path where the ontology in
which to search is stored. It can be omitted in case the option "onto_path"
has been define (see \code{getOption("onto_path")}).}
}
\value{
returns invisibly a table of the new harmonised concepts that were
added to the ontology, or a message that nothing new was added.
}
\description{
This adds a new concept to an existing ontology to semantically integrate and
thus harmonise it with the already existing ontology.
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")

new_concept(new = c("acacia", "miscanthus"),
            broader = c("Bioenergy woody", "Bioenergy herbaceous"),
            class = "crop",
            source = "external_dataset",
            path = ontoDir)

load_ontology(path = ontoDir)
}
