% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_tday.R
\name{make_tday}
\alias{make_tday}
\title{Make an hour-of-day data.frame with k-step ahead columns.}
\usage{
make_tday(time, kseq, tstep = 3600, units = "hours")
}
\arguments{
\item{time}{vector of times of class "POSIXct" "POSIXt".}

\item{kseq}{vector of integers, respresenting the desired "k-steps ahead".}

\item{tstep}{step time of k in seconds.}

\item{units}{to return in, e.g. "hours" or "mins"}
}
\value{
Returns a data.frame with rownames = times, colnames = k1, k2, k5, ...
The content of the data frame is the hour of day, following the setup in "onlineforecast" setup.
}
\description{
This function creates a data.frame with k-steps-ahead values of hour of day,
such that it can be added to a data.list and used inputs to a forecast model.
}
\examples{
# Create a time sequence
tseq <- seq(ct("2019-01-01"), ct("2019-02-01 12:00"), by=1800)

# Make the time of day sequence
make_tday(tseq, 1:10)

# With 0.5 hour steps and in minutes
make_tday(tseq, 1:10, tstep=1800, units="mins")


}
\keyword{data.frame}
\keyword{hourofday}
\keyword{lags}
