% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theme_status.R
\name{get_theme_status}
\alias{get_theme_status}
\title{Check Theme Status}
\usage{
get_theme_status(
  token,
  theme,
  date = Sys.Date(),
  time = format(Sys.time(), format = "\%T")
)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{theme}{Query name of theme. Themes’ query names can be retrieved using \code{\link{search_themes}}.}

\item{date}{Default = current date. Date to check for updates. Format YYYY-MM-DD}

\item{time}{Default = current time. Time to check for updates. Format: HH:MM:SS:FFFZ}
}
\value{
A named logical indicating if the theme is updated at a specific date.
If an error occurred, the function returns \code{NULL} along with a warning message.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#check-theme-status}{Check Theme Status API}. It returns a named logical indicating if the theme is updated at a specific date.
}
\examples{
# returns named logical
\dontrun{get_theme_status(token, "kindergartens")}
\dontrun{get_theme_status(token, "2020-01-01", "12:00:00", "hotels")}

# returns NULL, warning message shows status code
\dontrun{get_theme_status("invalid_token", "blood_bank")}

# returns NULL, warning message shows error
\dontrun{get_theme_status(token, "invalid_theme")}
}
