% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{empty_onemap_obj}
\alias{empty_onemap_obj}
\title{Produce empty object to avoid code break. Function for internal purpose.}
\usage{
empty_onemap_obj(vcf, P1, P2, cross)
}
\arguments{
\item{vcf}{object of class vcfR}

\item{P1}{character with parent 1 ID}

\item{P2}{character with parent 2 ID}

\item{cross}{type of cross. Must be one of: \code{"outcross"} for full-sibs;
\code{"f2 intercross"} for an F2 intercross progeny; \code{"f2 backcross"};
\code{"ri self"} for recombinant inbred lines by self-mating; or
\code{"ri sib"} for recombinant inbred lines by sib-mating.}
}
\value{
An empty object of class \code{onemap}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}. Markers for F2 intercrosses are coded as 1; all other crosses
are left as \code{NA}.} \item{input}{the name of the input file.}
\item{n.phe}{number of phenotypes.} \item{pheno}{a matrix with phenotypic
values. Each column contains data for a trait and each row represents an
individual.}
}
\description{
Produce empty object to avoid code break. Function for internal purpose.
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
