\name{rcd}
\alias{rcd}
\title{Rapid Chain Delineation}
\description{
  Implements the marker ordering algorithm \emph{Rapid Chain
    Delineation} (\cite{Doerge, 1996}).
}
\usage{
rcd(input.seq, LOD=0, max.rf=0.5, tol=10E-5)
}
\arguments{
  \item{input.seq}{an object of class \code{sequence}.}
  \item{LOD}{minimum LOD-Score threshold used when constructing the
    pairwise recombination fraction matrix.}
  \item{max.rf}{maximum recombination fraction threshold used as the LOD
    value above.}
  \item{tol}{tolerance for the C routine, i.e., the value used to evaluate
    convergence.}
}
\details{
  \emph{Rapid Chain Delineation} (\emph{RCD}) is an algorithm for marker
  ordering in linkage groups. It is not an exhaustive search method and,
  therefore, is not computationally intensive. However, it does not
  guarantee that the best order is always found. The only requirement is
  a matrix with recombination fractions between markers.
  Next is an excerpt from QTL Cartographer Version 1.17 Manual
  describing the \emph{RCD} algorithm (\cite{Basten et al., 2005}):
  
  \emph{The linkage group is initiated with the pair of markers having the
  smallest recombination fraction. The remaining markers are placed in a
  \dQuote{pool} awaiting placement on the map. The linkage group is
  extended by adding markers from the pool of unlinked markers. Each
  terminal marker of the linkage group is a candidate for extension of
  the chain: The unlinked marker that has the smallest recombination
  fraction with either is added to the chain subject to the provision
  that the recombination fraction is statistically significant at a
  prespecified level. This process is repeated as long as markers can be
  added to the chain.}

  After determining the order with \emph{RCD}, the final map is constructed
  using the multipoint approach (function \code{\link[onemap]{map}}).
}
\value{
  An object of class \code{sequence}, which is a list containing the
  following components:
  \item{seq.num}{a \code{vector} containing the (ordered) indices of
    markers in the sequence, according to the input file.}
  \item{seq.phases}{a \code{vector} with the linkage phases between markers
    in the sequence, in corresponding positions. \code{-1} means that there are
    no defined linkage phases.}
  \item{seq.rf}{a \code{vector} with the recombination frequencies between
    markers in the sequence. \code{-1} means that there are no estimated
    recombination frequencies.}
  \item{seq.like}{log-likelihood of the corresponding linkage map.}
  \item{data.name}{name of the object of class \code{outcross} with the
    raw data.}
  \item{twopt}{name of the object of class \code{rf.2pts} with the 2-point
    analyses.}
}
\references{
  Basten, C. J., Weir, B. S. and Zeng, Z.-B. (2005) \emph{QTL
    Cartographer Version 1.17: A Reference Manual and Tutorial for QTL
    Mapping}.
  
  Doerge, R. W. (1996) Constructing genetic maps by rapid chain
  delineation. \emph{Journal of Quantitative Trait Loci} 2: 121-132.

   Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia,
  A. A. F. (2009) Evaluation of algorithms used to order markers on
  genetics maps. \emph{Heredity} 103: 494-502.
}
\author{Gabriel R A Margarido, \email{gramarga@gmail.com}}
\seealso{
  \code{\link[onemap]{make.seq}}, \code{\link[onemap]{map}}
}
\examples{
\dontrun{
  #outcross example
  data(example.out)
  twopt <- rf.2pts(example.out)
  all.mark <- make.seq(twopt,"all")
  groups <- group(all.mark)
  LG1 <- make.seq(groups,1)
  LG1.rcd <- rcd(LG1)

  #F2 example
  data(fake.f2.onemap)
  twopt <- rf.2pts(fake.f2.onemap)
  all.mark <- make.seq(twopt,"all")
  groups <- group(all.mark)
  LG1 <- make.seq(groups,1)
  LG1.rcd <- rcd(LG1)
  LG1.rcd
}
}
\keyword{utilities}
