% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oii_association_measures.R
\name{association.measures}
\alias{association.measures}
\title{Measures of association}
\usage{
association.measures(x, y = NULL, warnings = FALSE)
}
\arguments{
\item{x}{a table or matrix if \code{y} is NULL, or a numeric vector for the row variable}

\item{y}{the column variable, a numeric vector used only when \code{x} is not a table or matrix.}

\item{warnings}{a logical value indicating whether warnings should be shown (defaults to FALSE, no warnings).}
}
\value{
A list with the following elements is returned:
  \item{phi}{Phi, a chi-square-based measures of association.}
  \item{contingency_coefficient}{Contingency coefficient, a chi-square-based measures of association.}
  \item{cramersv}{Cramer's V, a chi-square-based measures of association.}
  \item{pairs_total}{Total number of pairs}
  \item{pairs_concordant}{Number of concordant pairs}
  \item{pairs_discordant}{Number of discordant pairs}
  \item{pairs_tied_first}{The number of pairs tied on the first variable (but not both variables)}
  \item{pairs_tied_second}{The number of pairs tied on the second variable (but not both variables)}
  \item{pairs_tied_both}{The number of pairs tied on both the first and second variables}
  \item{minimum_dim}{Minimum dimension of \code{x} and \code{y}}
  \item{n}{Number of cases}
  \item{gamma}{Goodman-Kruskal Gamma}
  \item{somersd}{Somers' d (assuming the column variable is the dependent variable)}
  \item{taub}{Kendall's tau-b}
  \item{tauc}{Stuart's tau-c}
}
\description{
This function calculates basic measures of association
}
\examples{
#Create var1 as 200 A's, B's, and C's
var1<-sample(LETTERS[1:3],size=200,replace=TRUE)
#Create var2 as 200 numbers in the range 1 to 4
var2<-sample(1:4,size=200,replace=TRUE)

#Print a simple cross tab of var1 and var2
association.measures(var1,var2)
}
\seealso{
\code{\link{oii.xtab}}, \code{\link[Deducer]{likelihood.test}}, \code{\link[rapportools]{lambda.test}},
\code{\link{concordant.pairs}}, \code{\link{discordant.pairs}}, \code{\link{tied.pairs}}
}

