% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_cell.R
\name{fp_cell}
\alias{fp_cell}
\alias{format.fp_cell}
\alias{print.fp_cell}
\alias{update.fp_cell}
\title{Cell formatting properties}
\usage{
fp_cell(border = fp_border(width = 0), border.bottom, border.left,
  border.top, border.right, vertical.align = "center", margin = 0,
  margin.bottom, margin.top, margin.left, margin.right,
  background.color = "transparent", text.direction = "lrtb")

\method{format}{fp_cell}(x, type = "wml", ...)

\method{print}{fp_cell}(x, ...)

\method{update}{fp_cell}(object, border, border.bottom, border.left,
  border.top, border.right, vertical.align, margin = 0, margin.bottom,
  margin.top, margin.left, margin.right, background.color, text.direction,
  ...)
}
\arguments{
\item{border}{shortcut for all borders.}

\item{border.bottom, border.left, border.top, border.right}{\code{\link{fp_border}} for borders.}

\item{vertical.align}{cell content vertical alignment - a single character value,
expected value is one of "center" or "top" or "bottom"}

\item{margin}{shortcut for all margins.}

\item{margin.bottom, margin.top, margin.left, margin.right}{cell margins - 0 or positive integer value.}

\item{background.color}{cell background color - a single character value specifying a
valid color (e.g. "#000000" or "black").}

\item{text.direction}{cell text rotation - a single character value, expected
value is one of "lrtb", "tbrl", "btlr".}

\item{x, object}{\code{fp_cell} object}

\item{type}{output type - one of 'wml', 'pml', 'html'.}

\item{...}{further arguments - not used}
}
\description{
Create a \code{fp_cell} object that describes cell formatting properties.
}
\examples{
obj <- fp_cell(margin = 1)
update( obj, margin.bottom = 5 )
}
