\name{plot3d.prism}
\alias{plot3d.prism}

\title{
Function to plot the performance (accuracy, precision and statistical power) as a function of the number of individuals (x-axis) and replicates (y-axis) sampled.}
\description{
Function to plot the performance (accuracy, precision and statistical power; different colors depicting different levels) as a function of the number of individuals (x-axis) and replicates (y-axis) sampled. The function only plots dataframes of class 'odprism' that can be generated with the functions 'odprim', 'odpsrimB' and 'odprismU'. Accuracy/bias is calculated as the median of all parameter estimates for a specific model variable minus the value of that variable used to generate the data. Imprecision is calculated as the difference between the upper and lower quantile (e.g. 75percentile-25percentile) of all parameter estimates from the simulated datasets. Power is calculated as the proportion of simulations in which the variable of interest was significant at the level given by \code{alpha} in the simulation function. }
\usage{
plot3d.prism(x, variable, prec = 2, absol = TRUE, 
  zmax1 = 0, zmax2 = 0)
}
\arguments{
  \item{x}{ dataframe of class 'odprism' that can be generated by the functions 'odprim', 'odprismB' and 'odprismU'. }
  \item{variable}{ Variable from the mixed model applied to the data, e.g. 'b0, bX, bX2, VI, VS, C (coding for either CorIS or CovIS) or VR. }
  \item{prec}{ Determines which quantiles are used to estimate (im)precision. For example if function 'odprismB' was ran with \code{Quant=c(0.025,0.25,0.75,0.975)} then imprecision uses the inner quantiles 0.75 and 0.25 if \code{prec=1} and uses the outer quantiles 0.975 and 0.025 if \code{prec=2}. }
  \item{absol}{  If \code{absol=TRUE} the absolute value is taken of the accuracy/bias. }
  \item{zmax1}{  Determines the value beyond which values of accuracy/bias are truncated to improve readability of graphs. For example, if \code{zmax=1}, all values of bias>=1 are shown by the same colour.}
  \item{zmax2}{  Determines the value beyond which values of imprecision are truncated to improve readability of graphs. For example, if \code{zmax=1}, all values of imprecsion>=1 are shown by the same colour.}
}
\details{
If results were generated with the option \code{alpha=0} then the results for statistical power cannot be plotted.
}
\value{ Plots two to three graphs. Left panel: bias-inaccuracy. Middle panel: Imprecsion. Right panel: statistical power.  }
\references{
 van de Pol, M. 2012 Quantifying individual reaction norms: How study design affects the accuracy, precision and power of random regression models. Methods in Ecology & Evolution, In press.
}
\author{ Martijn van de Pol
}

\seealso{
\code{\link{odprim}}, \code{\link{odprismU}}, \code{\link{odprismB}}, \code{\link{plot2d.prism}}, \code{\link{DataExample}}
}
\examples{
## Note example uses only few sims to speed things up, normally sims>1000
results<-odprismB(indiv=c(10,25,50,75,100), repl=c(2,4,6,8,10), 
  random=c(0.2,0.1,0.5), sims=10, alpha=0.05)
results
plot3d.prism(x=results, variable="C")

## Alternatively look at an example datafile DataExample, 
## which is available with the package as an example.
## ensure that class(DataExample) = c("odprism", "data.frame")
## then run plot3d.prism(x=DataExample, variable="C") 
}
\keyword{ models}
\keyword{ methods}
